//
//  QGRepaymentViewController.m
//  VirtualPayment
//
//  Created by silicn on 2019/6/19.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGRepaymentViewController.h"
#import "QGRepaymentGroupViewController.h"
//views
#import "QGMonthSegmentView.h"
#import "QGPaymentStatusView.h"
#import "QGGradientView.h"
#import "QGRepaymentPieView.h"
#import "QGRepaymentBottomView.h"
#import "QGRepaymentListView.h"
#import "QGrepaymentSectionView.h"
#import "QGDefaultView.h"
//cells
#import "QGRepaymentOrderListCell.h"
#import "QGRepaymentStagesViewCell.h"
#import "QGRepaymentSectionCell.h"
#import "QGRepaymentOverDueCell.h"
#import "QGRepaymentListViewCell.h"

#import "QGRepaymentReuestApi.h"

// models
#import "QGRepaymentBillHeadModel.h"
#import "QGRepaymentBillModel.h"
#import "QGRepaymentAmortizeOrderModel.h"
#import "QGRepaymentOverdueModel.h"
#import "QGRepaymentBillSectionModel.h"

//listener
#import "QGRepaymentScollListener.h"

#import "NSString+QGURLParam.h"

#import "QGAnalyticsService.h"

#import "QGRepaymentCommitViewController.h"

#import "QGApplicationOpenURL.h"

@interface QGRepaymentViewController ()<UITableViewDelegate,UITableViewDataSource>

@property (nonatomic, strong) NSMutableArray *dataSource ;
/// 月份选择
@property (nonatomic, strong) QGMonthSegmentView *monthSegment ;
/// 账单状态视图
@property (nonatomic, strong) QGRepaymentListView *statusListView ;
/// 底部视图
@property (nonatomic, strong)QGRepaymentBottomView *bottomView;
/// 隐藏底部视图
@property (nonatomic, assign) BOOL isHiddenBottom;


@end

@implementation QGRepaymentViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // 设置Nav
    [self setNavBarIsGradientBar:YES];
    [self custemLeftWhiteBarButtonItem];
    [self setupNavBarTitleColor:[UIColor whiteColor] title:@"我的账单"];
    [self setupUI];

    if (self.billModel == nil) {
        /// 从历史账单跳转过来
        [self requestData];
    }
}

- (void)setupAnalyticsWith:(BOOL)isRight
{
    // 埋点统计
    if (self.billModel.isShould) {
        if (self.billHead.forwardUrl && self.billHead.installmentUrl) {
            /// 两个都有时 isRight才有意义，
            if (isRight) {
                QGAppCoreModelClickEvent *event = [QGAppCoreModelClickEvent acmcEventWithPage:@"账单还款页" path:@"应还账单" name:@"底部按钮点击" detail_name:@"分期还款"];
                [QGAnalyticsService analyticsTrackWithEvent:event];
            }else{
                QGAppCoreModelClickEvent *event = [QGAppCoreModelClickEvent acmcEventWithPage:@"账单还款页" path:@"应还账单" name:@"底部按钮点击" detail_name:@"立即还款"];
                [QGAnalyticsService analyticsTrackWithEvent:event];
            }
        }else{  // 如果就只有一个按钮， 有哪个点击哪个
            if (self.billHead.forwardUrl && [NSString isEmpty:self.billHead.installmentUrl]) {
                QGAppCoreModelClickEvent *event = [QGAppCoreModelClickEvent acmcEventWithPage:@"账单还款页" path:@"应还账单" name:@"底部按钮点击" detail_name:@"立即还款"];
                [QGAnalyticsService analyticsTrackWithEvent:event];
            }
            
            if (self.billHead.installmentUrl && [NSString isEmpty:self.billHead.forwardUrl]) {
                QGAppCoreModelClickEvent *event = [QGAppCoreModelClickEvent acmcEventWithPage:@"账单还款页" path:@"应还账单" name:@"底部按钮点击" detail_name:@"分期还款"];
                [QGAnalyticsService analyticsTrackWithEvent:event];
            }
        }
    }else{
        QGAppCoreModelClickEvent *event = [QGAppCoreModelClickEvent acmcEventWithPage:@"账单还款页" path:@"待还账单" name:@"底部按钮点击" detail_name:@"提前还款"];
        [QGAnalyticsService analyticsTrackWithEvent:event];
    }
}

- (void)setupUI
{
    self.isBelowNavBar = YES;
    /// 底部按钮
    self.bottomView = [[QGRepaymentBottomView alloc]init];
    [self.view insertSubview:_bottomView belowSubview:self.tableView];
    
    [self.bottomView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.equalTo(self.view);
        if (@available(iOS 11.0, *)) {
            make.bottom.equalTo(self.view.mas_safeAreaLayoutGuideBottom);
        } else {
            make.bottom.equalTo(self.view);
        }
        make.height.mas_equalTo(70);
    }];
    // 底部视图的点击事件
    @weakify(self);
    self.bottomView.actionBlock = ^(BOOL isRight) {
        @strongify(self);
    
        [self setupAnalyticsWith:isRight];
        [QGApplicationOpenURL handleAllSupportUrl:isRight ? self.billHead.appPreRepayUrl : self.billHead.appRepayUrl];
    };
    /// 设置tableView
    [self.tableView mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.view.mas_top).inset(self.shouldExtInsets?[DeviceAdaptation getNavBarAndStatusBarHeight]:0);
        make.left.right.bottom.equalTo(self.view);
    }];
    self.tableView.estimatedRowHeight = 60;
    self.tableView.bounces = NO;
    self.tableView.backgroundColor = [UIColor whiteColor];
    self.tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    self.tableView.rowHeight = UITableViewAutomaticDimension;
    self.tableView.scrollsToTop = YES;

//    // 超出父视图的HeadView,包含背景的渐变视图，QGRepaymentListView,
    QGHitTestView *headView = [[QGHitTestView alloc]initWithFrame:CGRectMake(0, 0, self.view.frame.size.width, 170)];
    self.tableView.tableHeaderView = headView;
    headView.backgroundColor = [UIColor whiteColor];

    // 渐变视图,Navgation下面的补充渐变背景
    QGGradientView *gradientView = [[QGGradientView alloc]initWithFrame:CGRectMake(0, 0, headView.frame.size.width, 120)];
    [headView addSubview:gradientView];

    // 头部状态视图以及详情列表
    QGRepaymentListView *listView = [[QGRepaymentListView alloc]init];
    [headView addSubview:listView];

    [listView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(headView);
        make.left.right.equalTo(headView);
        make.height.mas_equalTo([UIScreen mainScreen].bounds.size.height * 2);
    }];

    self.statusListView = listView;

    @weakify(headView);
    listView.canClickBlock = ^(BOOL canClick) {
        @strongify(headView);
        @strongify(self);
        if (canClick) {
            [self.tableView setContentOffset:CGPointMake(0,0) animated:YES];
        }
        headView.canClick = canClick;
    };
    /// statusView的点击事件
    @weakify(listView);
    listView.touchItemBlock = ^(QGRepaymentStatusBillItem * _Nonnull item) {
        @strongify(listView);
        if (item.url) {
            NSString *url = item.url;
            url = [url filterURLParam:@"billNumber" value:self.billModel.billNo];
            url = [url filterURLParam:@"itemPrice" value:item.content];
            [self navigationToWeb:url];
        }else{  // 本controller设置contentoffset
            [listView dismissBlurEffectView];
            if (self.dataSource.count) {
                [self.tableView scrollToRowAtIndexPath:[NSIndexPath indexPathForRow:0 inSection:0] atScrollPosition:UITableViewScrollPositionTop animated:YES];
            }
        }
    };
    
    listView.showAmountDetailBolck = ^{
        @strongify(self);
        [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGShouldAmountViewController) parameters:@{@"billModel":self.billModel} handlerBlock:nil];
    };
}

#pragma mark - NetWorking

/**
 请求账单信息
 */
- (void)requestData
{
     if (self.billId == nil) return;
    
    [QGHUDManager showHud:@""];
    QGTalosNetwork *networking = [QGTalosNetwork shareManager];
    NSMutableDictionary *param = [NSMutableDictionary dictionary];
    [param setValue:self.billId forKey:@"billNo"];
    if (self.yearMonth) {
        [param setObject:self.yearMonth forKey:@"yearMonth"];
    }
//    NSString * urlString = @"http://yapi.quantgroups.com/mock/169/vcc/bill_detail";
    NSString * urlString = [QGRepaymentReuestApi urlWithIndex:QGRepaymentRequestServerMethodBillDetail];
    [networking GET:urlString parameters:param success:^(id  _Nonnull responseObject) {
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            [QGHUDManager hideHud];
            NSDictionary *dic = responseObject[@"data"];
            self.billModel = [QGRepaymentBillModel yy_modelWithJSON:dic[@"bill"]];
            [self updateTableViewSourceWith:self.billModel];
        }else{
             [QGHUDManager showHudWithError:responseObject];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager hideHud];
        QGDefaultView * view = [QGDefaultView defaultViewShowWithSuperView:self.view inset:UIEdgeInsetsMake([DeviceAdaptation getNavBarAndStatusBarHeight], 0, 0, 0) reloadBlock:^{
            //开始下拉刷新
            [self requestData];
        }];
        view.viewType = QGDefaultViewTypeBadNetwork;
    }];
}

#pragma mark - Settings

- (void)setBillModel:(QGRepaymentBillModel *)billModel
{
    if (_billModel != billModel) {
        _billModel = billModel;
        [self updateTableViewSourceWith:_billModel];
    }
}



/**
 更新TableView的数据源

 @param model QGRepaymentBillModel
 */
- (void)updateTableViewSourceWith:(QGRepaymentBillModel *)model
{
    /// 初始化头部数据以及状态
    self.statusListView.model = model;
    NSString *title = [NSString stringWithFormat:@"%@年%@月账单",model.year,model.month];
    if (title) {
         [self setupNavBarTitleColor:[UIColor whiteColor] title:title];
    }
   
    [self.dataSource removeAllObjects];
    
    if (model.status == -1) {  // 需要特殊展示
        @weakify(self);
        QGDefaultView *backgroundView = [QGDefaultView defaultViewShowWithSuperView:nil reloadBlock:^{
            @strongify(self);
            NSString *url = self.billHead.forwardUrl;
            url = [url filterURLParam:@"billNumber" value:self.billHead.shouldBillNo];
            url = [url filterURLParam:@"itemPrice" value:self.shouldAmount];
            url = [url filterURLParam:@"addPrice" value:@"0"];
            url = [url filterURLParam:@"isBothBtn" value:@"false"];
            url = [url filterURLParam:@"from" value:self.billModel.isShould ? @"should":@"await"];
            
            [self navigationToWeb:url];
        }];
        self.tableView.backgroundView = backgroundView;
        [backgroundView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.bottom.equalTo(self.tableView);
            make.top.equalTo(self.tableView.mas_top).inset(64);
            make.width.equalTo(self.tableView);
            make.height.equalTo(self.tableView);
        }];
        [backgroundView setIconImageWithImageName:@"repayment_empty_overdue" messageTitle:@"您有上月逾期账单未还！" buttonTitle:@"去还款"];
    }else{
        // 逾期账单列表
        if (model.overdueBillList.count) {
            [self.dataSource addObjectsFromArray:model.overdueBillList];
        }
        // 普通账单列表
        if (model.amortizeOrderList.count || model.noAmortizeOrderList.count) {
            NSString * title = [NSString stringWithFormat:@"本月账单明细%lu笔",model.amortizeOrderList.count + model.noAmortizeOrderList.count];
            QGRepaymentBillSectionModel *section = [[QGRepaymentBillSectionModel alloc]initWithTitle:title smallFont:NO descText:model.billTradeCycle];
            [self.dataSource addObject:section];
             [self.dataSource addObjectsFromArray:model.amortizeOrderList];
        }
        // 分期账单列表
        if (model.noAmortizeOrderList.count) {
            QGRepaymentBillSectionModel *section = [[QGRepaymentBillSectionModel alloc]initWithTitle:@"分期" smallFont:YES descText:nil];
            [self.dataSource addObject:section];
            [self.dataSource addObjectsFromArray:model.noAmortizeOrderList];
        }
       // 加载空视图 DefaultView
        if (self.dataSource.count == 0) {
            QGDefaultView *backgroundView = [QGDefaultView defaultViewShowWithSuperView:nil reloadBlock:^{
            }];
            self.tableView.backgroundView = backgroundView;
            [backgroundView mas_makeConstraints:^(MASConstraintMaker *make) {
                make.top.equalTo(self.tableView.mas_top).inset(90);
                make.left.right.bottom.equalTo(self.tableView);
                make.width.height.equalTo(self.tableView);
            }];
            backgroundView.reloadButton.hidden = YES;
            [backgroundView setIconImageWithImageName:@"repayment_empty_nomal" messageTitle:@"暂无账单明细" buttonTitle:@"去还款"];
        }else{
            self.tableView.backgroundView = nil;
        }
         // 更新底部Button
        [self updateBottomViewWith:model];
    }
     [self.tableView reloadData];
    
}


/**
 更新底部Button按钮的文字和事件

 @param model QGRepaymentBillModel ///账单状态 已还清0/应还1/还款中2/逾期3
 */
- (void)updateBottomViewWith:(QGRepaymentBillModel *)model
{
    /// 历史账单明细页面底部隐藏
    if (self.isHiddenBottom) {
        [self.tableView mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.top.equalTo(self.view.mas_top).inset(self.shouldExtInsets ?[DeviceAdaptation getNavBarAndStatusBarHeight]:0);
            make.left.right.bottom.equalTo(self.view);
        }];
        return;
    }
    
    if (model.status == 1 || model.status == 2){
        // 如果立即还款的按钮都没有，直接隐藏
        if ([NSString isEmpty:self.billHead.forwardUrl]) {
            [self.tableView mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.top.equalTo(self.view.mas_top).inset(self.shouldExtInsets ?[DeviceAdaptation getNavBarAndStatusBarHeight]:0);
                make.left.right.bottom.equalTo(self.view);
            }];
        }else{
            // 显示底部
            [self.tableView mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.top.equalTo(self.view.mas_top).inset(self.shouldExtInsets ?[DeviceAdaptation getNavBarAndStatusBarHeight]:0);
                make.left.right.equalTo(self.view);
                make.bottom.equalTo(self.bottomView.mas_top);
            }];
            // 是否可以点击
            self.bottomView.canUserExpress = model.status == 2 ? NO:YES;
             //可能显示一个或者两个  待还显示一个
            if (model.isShould) {
                if (self.billHead.forwardUrl && self.billHead.installmentUrl) {
                    self.bottomView.type = RepaymentBottomTypeNomal;
                    [self.bottomView setLeftTitle:@"立即还款" rightTitle:self.billHead.installmentName];
                }else{
                    self.bottomView.type = RepaymentBottomTypeSignle;
                    [self.bottomView setLeftTitle:nil rightTitle:@"立即还款"];
                }
            }else{
                self.bottomView.type = RepaymentBottomTypeSignle;
                [self.bottomView setLeftTitle:nil rightTitle:@"提前还款"];
            }
        }
    }else if (model.status == 3){ //逾期只能立即还款
        [self.tableView mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.top.equalTo(self.view.mas_top).inset(self.shouldExtInsets ?[DeviceAdaptation getNavBarAndStatusBarHeight]:0);
            make.left.right.equalTo(self.view);
            make.bottom.equalTo(self.bottomView.mas_top);
        }];
        self.bottomView.type = RepaymentBottomTypeSignle;
        [self.bottomView setLeftTitle:nil rightTitle:@"立即还款"];
        
    }else{ // 不显示
        [self.tableView mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.top.equalTo(self.view.mas_top).inset(self.shouldExtInsets ?[DeviceAdaptation getNavBarAndStatusBarHeight]:0);
            make.left.right.bottom.equalTo(self.view);
        }];
    }
}

#pragma mark - TableView Delegate And DataSource


- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return CGFLOAT_MIN;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return CGFLOAT_MIN;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.dataSource.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    id objc = self.dataSource[indexPath.row];
    if ([objc isKindOfClass:[QGRepaymentBillSectionModel class]]) {
        QGRepaymentSectionCell * cell = (QGRepaymentSectionCell *)[self getCellFromClassName:NSStringFromClass([QGRepaymentSectionCell class]) dequeueTableView:tableView];
        cell.model = (QGRepaymentBillSectionModel *)objc;
        return cell;
    }else if ([objc isKindOfClass:[QGRepaymentOverdueModel class]]){
        QGRepaymentOverDueCell * cell = (QGRepaymentOverDueCell *)[self getCellFromClassName:NSStringFromClass([QGRepaymentOverDueCell class]) dequeueTableView:tableView];
        cell.model = (QGRepaymentOverdueModel *)objc;
        return cell;
    }else{
        QGRepaymentAmortizeOrderModel *model = self.dataSource[indexPath.row];
        //消费订单
        if (model.orderType == 0) {
            QGRepaymentOrderListCell * cell = (QGRepaymentOrderListCell *)[self getCellFromClassName:NSStringFromClass([QGRepaymentOrderListCell class]) dequeueTableView:tableView];
            cell.model = model;
            return cell;
        }
        //分期订单
        else{
            QGRepaymentStagesViewCell * cell = (QGRepaymentStagesViewCell *)[self getCellFromClassName:NSStringFromClass([QGRepaymentStagesViewCell class]) dequeueTableView:tableView];
            cell.model = model;
            return cell;
        }
    }
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    id objc = self.dataSource[indexPath.row];
    if ([objc isKindOfClass:[QGRepaymentBillSectionModel class]] || [objc isKindOfClass:[QGRepaymentOverdueModel class]]) {
        return ;
    }else if([objc isKindOfClass:[QGRepaymentAmortizeOrderModel class]]){
        QGRepaymentAmortizeOrderModel *model = (QGRepaymentAmortizeOrderModel *)objc;
        NSString *url = model.orderType == 0 ? model.orderUrl : model.installmentUrl;
        /// v1.7.00 版本中删除
//        url = [url filterURLParam:@"orderNumber" value:model.orderNo];
//        url  = [url filterURLParam:@"itemPrice" value:model.orderAmount];
//        url = [url filterURLParam:@"installmentType" value:[NSString stringWithFormat:@"%@",model.installmentType ?@"orderType":@"billType"]];
        [self navigationToWeb:url];
    }
    
}

/**
 滑动事件接受监听

 @param scrollView tableView
 */
- (void)scrollViewDidScroll:(UIScrollView *)scrollView
{
    if (self.listenScroll) {
         [QGRepaymentScollListener shareInstance].scrollBlock(scrollView.contentOffset);
    }
}

- (void)viewWillDisappear:(BOOL)animated
{
    [super viewWillDisappear:animated];
}

- (NSMutableArray *)dataSource
{
    if (!_dataSource) {
        _dataSource = [NSMutableArray array];
    }
    return _dataSource;
}

- (UIStatusBarStyle)preferredStatusBarStyle
{
    return UIStatusBarStyleLightContent;
}

#pragma mark - 传参

/**
 检查入参是否正确 需要子类重写
 
 @param param 入参
 @return 返回参数检查是否通过
 */
- (BOOL)checkParameters:(NSDictionary *)param {
    if ([param objectForKey:@"billId"] || [param objectForKey:@"billModel"]) {
        return YES;
    }
    return NO;
}

/**
 传参函数 需要子类重写
 
 进入页面前需要传递该页面必须的参数
 @param param 入参
 */
- (void)transferParameters:(NSDictionary *)param {
    self.shouldExtInsets = [[param objectForKey:@"shouldExtInsets"] boolValue];
    self.isHiddenBottom = [[param objectForKey:@"isHiddenBottom"] boolValue];
    self.yearMonth = [param objectForKey:@"yearMonth"];
    self.billId = [param objectForKey:@"billId"];
    self.billModel = [param objectForKey:@"billModel"];
    self.billHead = [param objectForKey:@"billHead"];
}


/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
