//
//  QGPayModeViewCell.m
//  VirtualPayment
//
//  Created by silicn on 2020/5/22.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGPayCardViewCell.h"
#import "QGBasicUITool.h"

@interface QGPayCardViewCell ()

@property (nonatomic, strong) UILabel *cardLab ;

@property (nonatomic, strong) UILabel *desLab ;

@end

@implementation QGPayCardViewCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(nullable NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        UILabel *nameLab = [UILabel creatLabelWithSuperView:self.contentView title:@"付款方式" titleFontSize:[UIFont qg_lightFontOfSize:14.0f] textColor:UIColor.textColor9999 alignment:NSTextAlignmentLeft];
        [nameLab mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(20);
            make.centerY.equalTo(self.contentView);
        }];
        
        [nameLab setContentCompressionResistancePriority:UILayoutPriorityDefaultHigh forAxis:UILayoutConstraintAxisHorizontal];
        
        self.cardLab = [UILabel creatLabelWithSuperView:self.contentView title:@"中国建设银行(8888)" titleFontSize:[UIFont qg_lightFontOfSize:14.0f] textColor:UIColor.textColor3333 alignment:NSTextAlignmentRight];
        [self.cardLab mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.equalTo(self.arrowImage.mas_left).offset(-10);
            make.centerY.equalTo(self.contentView.mas_centerY).offset(-10);
            make.left.greaterThanOrEqualTo(nameLab.mas_right).offset(10);
        }];
        
        UILabel *desLab = [UILabel creatLabelWithSuperView:self.contentView title:@"限额" titleFontSize:[UIFont qg_lightFontOfSize:11.0f] textColor:UIColor.textColor9999 alignment:NSTextAlignmentRight];
        [desLab mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.equalTo(self.cardLab);
            make.top.equalTo(self.cardLab.mas_bottom).offset(2);
        }];
        self.desLab = desLab;
    }
    return self;
}

- (void)setBankName:(NSString *)bankName
{
    _bankName = bankName;
    self.cardLab.text = bankName;
}

- (void)setLimitDes:(NSString *)limitDes
{
    _limitDes = limitDes;
    self.desLab.text = limitDes;
}

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
