//
//  QGDepositeHeaderView.m
//  VirtualPayment
//
//  Created by silicn on 2020/4/1.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGDepositeHeaderView.h"

#import "QGBasicUITool.h"

#import "QGDepositeCardModel.h"


@interface QGDepositeHeaderView ()


@property (nonatomic, strong) UILabel *limitLab ;

@property (nonatomic, strong) QGDepositCourseView *courseView;


@end

@implementation QGDepositeHeaderView

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setups];
    }
    return self;
}

- (void)setups
{
    ///白色背景
    UIView *backView = [UIView creatViewWithSuperView:self backgroundColor:UIColor.whiteColor];
    [backView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.top.equalTo(self);
        make.height.mas_equalTo(172);
    }];
    
    /// 转入转出银行卡
    QGDepositCourseView *courseView = [[QGDepositCourseView alloc]init];
    [backView addSubview:courseView];
    
    self.courseView = courseView;
    
    [courseView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.inset(15);
        make.left.right.inset(20);
        make.height.mas_equalTo(110);
    }];
    ///限额说明
    UILabel *limitLab = [UILabel creatLabelWithSuperView:backView title:@"单笔最高限额****元，单笔最低限额****元" titleFontSize:[UIFont qg_regularFontOfSize:12.0f] textColor:UIColor.textColor9999 alignment:NSTextAlignmentLeft];
    [limitLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.inset(20);
        make.top.equalTo(courseView.mas_bottom).offset(15);
    }];
    self.limitLab = limitLab;
}

- (void)setFromModel:(QGDepositeCardModel *)fromModel
{
    if (_fromModel != fromModel) {
        _fromModel = fromModel;
        self.courseView.fromModel = fromModel;
        
        if (self.type == QGDepositTypeOut) { /// 转出提示文案
            self.limitLab.text = [NSString stringWithFormat:@"本次最多可转出%@元",fromModel.maxAmount];
        }else{  /// 转入
            self.limitLab.text = [NSString stringWithFormat:@"单笔最高限额%@元，单笔最低限额%@元",fromModel.maxAmount,fromModel.minAmount];
        }
    }
}

- (void)setToModel:(QGDepositeCardModel *)toModel
{
    if (_toModel != toModel) {
        _toModel = toModel;
        self.courseView.toModel = toModel;
    }
}

- (void)setType:(QGDepositType)type
{
    _type = type;
    self.courseView.type = type;
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
