//
//  QGDepositTipViewCell.m
//  VirtualPayment
//
//  Created by silicn on 2020/4/1.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGDepositTipViewCell.h"

#import "QGBasicUITool.h"


@interface QGDepositTipViewCell()

@property (nonatomic, strong) UILabel *tipLab ;

@end

@implementation QGDepositTipViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        self.backgroundColor = UIColor.clearColor;
        self.contentView.backgroundColor = UIColor.clearColor;
        [self setups];
    }
    return self;
}

- (void)setups
{
    UILabel *titleLab = [UILabel creatLabelWithSuperView:self.contentView title:@"温馨提示" titleFontSize:[UIFont qg_mediumFontOfSize:14.0f] textColor:UIColor.textColor3333 alignment:NSTextAlignmentLeft];
    [titleLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.inset(20);
        make.top.inset(10);
    }];
    
    UIView *backView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor moduleSeparatorColorF7F7]];
    backView.layer.cornerRadius = 5;
    backView.clipsToBounds = YES;
    [backView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(titleLab.mas_bottom).offset(8);
        make.left.right.inset(20);
        make.bottom.inset(10);
    }];
    
    self.tipLab = [UILabel creatLabelWithSuperView:backView title:self.tip titleFontSize:[UIFont qg_lightFontOfSize:12.0f] textColor:[UIColor colorWithHexString:@"#A3A3A3"] alignment:NSTextAlignmentLeft];
    _tipLab.numberOfLines = 0;
    [self.tipLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.bottom.inset(15);
        make.left.right.inset(20);
    }];
    
}

- (void)setTip:(NSString *)tip
{
    if (_tip != tip) {
        _tip = tip;
        self.tipLab.text = tip;
    }
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
