//
//  QGPwdDotView.m
//  VirtualPayment
//
//  Created by silicn on 2020/4/2.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGPwdDotView.h"
#import "QGBasicUITool.h"

@interface QGPwdDotView ()

@property (nonatomic, strong)UIView *dot;

@end

@implementation QGPwdDotView

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.backgroundColor = UIColor.clearColor;
        UIView *dot = [UIView creatViewWithSuperView:self backgroundColor:UIColor.textColor3333];
        dot.layer.cornerRadius = 6;
        dot.clipsToBounds = YES;
        dot.hidden = YES;
        _dotVisible = NO;
        [self addSubview:dot];
        self.dot = dot;
        
        [dot mas_makeConstraints:^(MASConstraintMaker *make) {
            make.width.height.mas_equalTo(12);
            make.centerX.centerY.equalTo(self);
        }];
    }
    return self;
}

- (void)setDotVisible:(BOOL)dotVisible
{
    if (_dotVisible != dotVisible) {
        _dotVisible = dotVisible;
        self.dot.hidden = !dotVisible;
    }
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
