//
//  QGDepositPwdView.m
//  VirtualPayment
//
//  Created by silicn on 2020/4/2.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGDepositPwdView.h"
#import "QGDesignatedCornerView.h"
#import "QGPwdTextView.h"
#import "QGDepositeCardModel.h"
#import "QGBasicUITool.h"
#import "Mediator.h"
#import "QGMediatorClassTools.h"

@interface QGDepositPwdView ()

///背景
@property (nonatomic, strong) QGDesignatedCornerView *backView ;

/// 密码框
@property (nonatomic, strong) QGPwdTextView *textView;

///转入转出标题
@property (nonatomic, strong) UILabel *depositeTitleLab;
///转出转入图标
@property (nonatomic, strong) UIImageView *depositeImageV ;
///金额
@property (nonatomic, strong) UILabel *amountLab ;
/// 银行账户
@property (nonatomic, strong) UILabel *acountLab ;
/// 错误信息反馈
@property (nonatomic, strong) UILabel *errorLab ;

@property (nonatomic, strong) UILabel *acountTitleLab ;

///交易结果回调
@property (nonatomic, copy) QGDepositResultBlock resultBlock ;

@end

@implementation QGDepositPwdView


- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        _type = QGDepositTypeIn;
        [self setups];
        @weakify(self);
        self.resultBlock = ^(QGDepositResultType type, NSString * _Nonnull message) {
            @strongify(self);
            if (type == QGDepositResultTypeSuccess) {
                self.errorLab.text = nil;
                [self dismissView:NULL];
            }else if(type == QGDepositResultTypeFailureForPwd){
                /// 错误信息
                self.message = message;
                /// 清空输入的密码
                [self.textView cleanInputContent];
            }else{
                [self dismissView:NULL];
            }
            
        };
    }
    return self;
}

- (void)setups
{
    self.popType = PopViewTypeActionSheet;
    
    self.contentView.backgroundColor = UIColor.clearColor;
    ///白色圆角背景
    QGDesignatedCornerView *backView = [[QGDesignatedCornerView alloc]initWithRadius:20 corner:UIRectCornerTopLeft | UIRectCornerTopRight];
    backView.backgroundColor = UIColor.whiteColor;
    [self.contentView addSubview:backView];
    self.backView = backView;
    
    [backView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self.contentView);
    }];
    /// 标题
    UILabel *titleLab = [UILabel creatLabelWithSuperView:backView title:@"请输入享花卡交易密码" titleFontSize:[UIFont qg_regularFontOfSize:13.0f] textColor:UIColor.textColor9999 alignment:NSTextAlignmentCenter];
    [titleLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.inset(15);
        make.centerX.equalTo(backView);
    }];
    /// 关闭按钮
    UIButton *closeBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [closeBtn setImage:[UIImage imageNamed:@"deposit_pwd_close"] forState:UIControlStateNormal];
    closeBtn.contentHorizontalAlignment = UIControlContentHorizontalAlignmentRight;
    [backView addSubview:closeBtn];
    
    [closeBtn addTarget:self action:@selector(closeBtnAction:) forControlEvents:UIControlEventTouchUpInside];
    
    [closeBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.inset(15);
        make.width.mas_equalTo(40);
        make.centerY.equalTo(titleLab);
    }];
    ///线
    UIView *line = [UIView creatViewWithSuperView:backView backgroundColor:[UIColor colorWithHexString:@"#D8D8D8"]];
    [line mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.inset(0);
        make.top.equalTo(titleLab.mas_bottom).offset(15);
        make.height.mas_equalTo(0.5);
    }];
    ///转入转出标题
    UILabel *depositeTitleLab = [UILabel creatLabelWithSuperView:backView title:@"转入金额" titleFontSize:[UIFont qg_lightFontOfSize:13.0f] textColor:UIColor.textColor3333 alignment:NSTextAlignmentCenter];
    [depositeTitleLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(line.mas_bottom).offset(11);
        make.centerX.equalTo(backView).offset(13);
    }];
    self.depositeTitleLab = depositeTitleLab;
    
    /// 转入转出图标
    UIImageView *depositeImageV = [UIImageView creatImageViewWithSuperView:backView imageName:@"deposit_in"];
    [depositeImageV mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.height.mas_equalTo(14);
        make.centerY.equalTo(depositeTitleLab);
        make.right.equalTo(depositeTitleLab.mas_left).offset(-5);
    }];
    self.depositeImageV = depositeImageV;
    
    ///金额
    UILabel *amountLab = [UILabel creatLabelWithSuperView:backView title:@"0.00" titleFontSize:[UIFont qg_numberFontOfSize:26.0f] textColor:UIColor.textColor3333 alignment:NSTextAlignmentCenter];
    [amountLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(depositeTitleLab.mas_bottom).offset(5);
        make.centerX.equalTo(backView);
    }];
    self.amountLab = amountLab;
    /// 转出账户
    UILabel *acountTitleLab = [UILabel creatLabelWithSuperView:backView title:@"转出账户" titleFontSize:[UIFont qg_lightFontOfSize:14.0f] textColor:UIColor.textColor9999 alignment:NSTextAlignmentLeft];
    [acountTitleLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.inset(25);
        make.top.equalTo(amountLab.mas_bottom).offset(12);
    }];
    self.acountTitleLab = acountTitleLab;
    
    ///转出账户具体银行
    UILabel *acountLab = [UILabel creatLabelWithSuperView:backView title:@"**银行(****)" titleFontSize:[UIFont qg_lightFontOfSize:14.0] textColor:UIColor.textColor3333 alignment:NSTextAlignmentRight];
    [acountLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(acountTitleLab.mas_right).offset(8);
        make.centerY.equalTo(acountTitleLab);
        make.right.inset(25);
    }];
    self.acountLab = acountLab;
    
    [acountTitleLab setContentHuggingPriority:UILayoutPriorityRequired
                                 forAxis:UILayoutConstraintAxisHorizontal];
    [acountLab setContentHuggingPriority:UILayoutPriorityDefaultLow
                                 forAxis:UILayoutConstraintAxisHorizontal];
    /// 密码框
    QGPwdTextView *textView = [[QGPwdTextView alloc]init];
    [backView addSubview:textView];
    
    [textView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.inset(25);
        make.top.equalTo(acountTitleLab.mas_bottom).offset(15);
        make.height.mas_equalTo(55);
    }];
    self.textView = textView;
    /// 输入内容变化回调
    @weakify(self);
    self.textView.inputBlock = ^(BOOL complete, NSString * _Nonnull pwd) {
        @strongify(self);
        /// 密码输入完成
        if (complete) {
            if (self.inputPwdCompleteBlock && pwd) {
                self.inputPwdCompleteBlock(pwd);
            }
        }
        /// 一旦输出,错误提示消失
        if (self.errorLab.text) {
            self.errorLab.text = nil;
        }
    };
    
    /// 密码次数错误信息
    UILabel *errorLab = [UILabel creatLabelWithSuperView:backView title:@"" titleFontSize:[UIFont qg_lightFontOfSize:12.0f] textColor:UIColor.yyMainThemeColor alignment:NSTextAlignmentLeft];
    [errorLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.inset(25);
        make.top.equalTo(textView.mas_bottom).offset(15);
    }];
    self.errorLab = errorLab;
    
    /// 忘记密码
    UIButton *forgetBtn  = [UIButton creatButtonWithSuperView:backView title:@"忘记密码?" titleFont:[UIFont qg_lightFontOfSize:14.0f] textColor:UIColor.textColor6666];
    [forgetBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(textView.mas_bottom).offset(15);
        make.right.inset(25);
        make.height.mas_equalTo(25);
        make.bottom.inset(25);
    }];
    [forgetBtn addTarget:self action:@selector(forgetBtnAction:) forControlEvents:UIControlEventTouchUpInside];
    
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(keyboardWillShowNotification:) name:UIKeyboardWillShowNotification object:nil];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(keyboardWillHideNotification:) name:UIKeyboardWillHideNotification object:nil];
    
    /// 交易结果回调
}

- (void)keyboardWillShowNotification:(NSNotification *)not
{
    NSDictionary *userInfo = not.userInfo;
    CGRect keyboardBounds = [[userInfo objectForKey:UIKeyboardFrameEndUserInfoKey] CGRectValue];
    //获取键盘动画的duration
    CGFloat duration = [[userInfo objectForKey:UIKeyboardAnimationDurationUserInfoKey] doubleValue];
       //获取键盘的高度，计算textField需要平移的高度
    CGFloat deltaY = keyboardBounds.size.height;
    
    [UIView animateWithDuration:duration animations:^{
        self.transform = CGAffineTransformMakeTranslation(0, -deltaY);
    } completion:NULL];
    
    
    
}

- (void)keyboardWillHideNotification:(NSNotification *)not
{
    NSDictionary *userInfo = not.userInfo;
//      CGRect keyboardBounds = [[userInfo objectForKey:UIKeyboardFrameEndUserInfoKey] CGRectValue];
      //获取键盘动画的duration
      CGFloat duration = [[userInfo objectForKey:UIKeyboardAnimationDurationUserInfoKey] doubleValue];
      
      [UIView animateWithDuration:duration animations:^{
          self.transform = CGAffineTransformIdentity;
      } completion:NULL];
}

///忘记密码
- (void)forgetBtnAction:(UIButton *)btn
{
    
    if (self.forgetURL) {
        [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGBaseWebViewController) parameters:@{@"urlString":self.forgetURL} handlerBlock:NULL];
    }
    
    [self dismissView:NULL];
  
}

- (void)closeBtnAction:(UIButton *)btn
{
    [self dismissView:NULL];
}

/// 重写父类方法
- (void)dismissView:(PopViewDisMissBlock)dismissBlock
{
    [self.textView resignFirstResponder];
    [super dismissView:dismissBlock];
}

/// 重写父类方法
- (void)showInView:(UIView *)superView
{
    self.contentView.alpha = 1.0;
    UIWindow *window = superView.window ? superView.window:[self getKeyWindow];
    [window addSubview:self];
    //self添加约束
    [self mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.bottom.right.left.equalTo(window);
    }];
    if (self.popType == PopViewTypeActionSheet) {
        [self layoutIfNeeded];   //布局一下self.contentView的视图位置
        //为contentView重新添加视图
        if (@available(iOS 11.0, *)) {
            [self.contentView mas_remakeConstraints:^(MASConstraintMaker *make) {
                   make.left.right.bottom.equalTo(self.mas_safeAreaLayoutGuide);
                   make.height.greaterThanOrEqualTo(@(55));
                   make.height.lessThanOrEqualTo(@([UIScreen mainScreen].bounds.size.height - 40 - [DeviceAdaptation getBottomSafeAreaHeight]));
            }];
        }else{
            [self.contentView mas_remakeConstraints:^(MASConstraintMaker *make) {
                   make.left.right.bottom.equalTo(self);
                   make.height.greaterThanOrEqualTo(@(55));
                   make.height.lessThanOrEqualTo(@([UIScreen mainScreen].bounds.size.height - 40));
            }];
        }
        //背景色渐变
        [UIView animateWithDuration:0.25 delay:0 options:UIViewAnimationOptionCurveEaseInOut animations:^{
            self.backgroundColor = [UIColor colorWithWhite:0 alpha:self.shadowViewAnimationAlpha];
        } completion:NULL];
           
       }else{
           //Alert类型动画
           self.contentView.layer.transform = CATransform3DMakeScale(1.1f, 1.1f, 1.0f);
           [UIView animateWithDuration:0.25f delay:0 options:UIViewAnimationOptionCurveEaseInOut animations:^{
               self.backgroundColor = [UIColor colorWithWhite:0 alpha:self.shadowViewAnimationAlpha];
               self.contentView.layer.transform = CATransform3DIdentity;
           } completion:NULL];
       }

    [self.textView becomeFirstResponder];
}


- (void)setType:(QGDepositType)type
{
    if (_type != type) {
        _type = type;
        if (type == QGDepositTypeIn) {
            self.acountTitleLab.text = @"转出账户";
            self.depositeTitleLab.text = @"转入金额";
            self.depositeImageV.image = [UIImage imageNamed:@"deposit_in"];
            [self.depositeTitleLab mas_updateConstraints:^(MASConstraintMaker *make) {
                make.centerX.equalTo(self.backView).offset(13);
            }];
        }else if (type == QGDepositTypeOut){
            self.acountTitleLab.text = @"转出账户";
            self.depositeTitleLab.text = @"转出金额";
            self.depositeImageV.image = [UIImage imageNamed:@"deposit_out"];
            [self.depositeTitleLab mas_updateConstraints:^(MASConstraintMaker *make) {
                make.centerX.equalTo(self.backView).offset(13);
            }];
        }else if (type == QGDepositTypeRepay){
            self.acountTitleLab.text = @"付款方式";
            self.depositeTitleLab.text = @"享花卡还款";
            self.depositeImageV.image = nil;
            [self.depositeTitleLab mas_updateConstraints:^(MASConstraintMaker *make) {
                make.centerX.equalTo(self.backView);
            }];
        }
    }
}

- (void)setCard:(QGDepositeCardModel *)card
{
    _card = card;
    if (self.type == QGDepositTypeRepay) {
        self.acountLab.text = [NSString stringWithFormat:@"%@(%@)",card.bankName,card.tailCardNo];
    }else{
        self.acountLab.text = [NSString stringWithFormat:@"%@%@(%@)",card.bankName,card.type,card.tailCardNo];
    }
}

- (void)setAmount:(NSString *)amount
{
    if (_amount != amount) {
        _amount = amount;
        self.amountLab.text = [NSString stringWithFormat:@"￥%.2f",[amount floatValue]];
    }
}

- (void)setMessage:(NSString *)message
{
    if (_message != message) {
        _message = message;
        self.errorLab.text = message;
    }
}



- (void)dealloc
{
    NSLog(@"QGDepositPwdView Dealloc");
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
