//
//  QGDepositPwdView.h
//  VirtualPayment
//
//  Created by silicn on 2020/4/2.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGBasePopView.h"

#import "QGDeposit.h"

@class QGDepositeCardModel;

typedef NS_ENUM(NSInteger,QGDepositResultType)
{
    QGDepositResultTypeSuccess = 1,  /// 交易结果成功,下落密码框
    QGDepositResultTypeFailure,      /// 交易结果失败,下落密码框
    QGDepositResultTypeFailureForPwd,/// 密码错误交易失败,不下落密码框
};

NS_ASSUME_NONNULL_BEGIN

typedef void(^QGDepositInputPwdCompleteBlock)(NSString *pwd);

typedef void(^QGDepositResultBlock)(QGDepositResultType type,NSString * _Nullable message);

@interface QGDepositPwdView : QGBasePopView

/// 转入转出
@property (nonatomic, assign) QGDepositType type;

/// 转出银行卡
@property (nonatomic, strong) QGDepositeCardModel *card ;

/// 金额
@property (nonatomic, copy) NSString *amount;

/// 错误信息
@property (nonatomic, copy) NSString *message ;

///忘记密码
@property (nonatomic,copy) NSString *forgetURL;

///密码输入完成回调
@property (nonatomic, copy) QGDepositInputPwdCompleteBlock inputPwdCompleteBlock ;

///交易结果回调
@property (nonatomic, copy,readonly) QGDepositResultBlock resultBlock ;

@end

NS_ASSUME_NONNULL_END
