//
//  QGDepositPwdManager.m
//  VirtualPayment
//
//  Created by silicn on 2020/4/3.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGDepositPwdManager.h"

#import "QGHUDManager.h"

#import "QGDepositPwdView.h"

#import "QGAlertView.h"

#import "QGDepositeCardModel.h"

#import "QGTalosNetwork.h"

#import "NSString+QGEncryption.h"

#import "QGDepositRequestApi.h"

#import "QGRepaymentReuestApi.h"


@interface QGDepositPwdManager()

///密码框
@property (nonatomic, strong) QGDepositPwdView *pwdView ;
/// 密码验证结果,外部不可使用
@property (nonatomic, copy) QGDepositResultBlock resultBlock;
///密码总次数
@property (nonatomic, assign) NSInteger totalCount;
///输入错误次数
@property (nonatomic, assign) NSInteger errorCount;
/// 忘记密码
@property (nonatomic, copy) NSString *forgetURL;

@end

@implementation QGDepositPwdManager


+ (instancetype)shareManager
{
    static QGDepositPwdManager *manager = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        manager = [[self alloc]init];
        manager.type = QGDepositTypeIn;
        manager.errorCount = 0;
    });
    return manager;
}

+ (instancetype)defaultMangerWithType:(QGDepositType)type amount:(NSString *)amount card:(QGDepositeCardModel *)card
{
    QGDepositPwdManager *manager = [self shareManager];
    manager.type = type;
    manager.amount = amount;
    manager.card = card;
    return manager;
}

- (void)showInView:(UIView *)superView
{
    self.superView = superView;
    /// 查询密码可用次数
    [self queryPwdAvailable];
    
}

- (BOOL)paramIsAvailable
{
    if (!self.amount || [self.amount isEqualToString:@""] || [self.amount floatValue] <= 0) {
        return NO;
    }
    
    if (!self.card) {
        return NO;
    }
    return YES;
}

- (void)queryPwdAvailable
{
    
    if (![self paramIsAvailable]) {
        [QGHUDManager showHud:@"参数缺少,请稍后再试"];
        return;
    }
    [QGHUDManager showHud:nil];
   
    QGTalosNetwork *networking = [QGTalosNetwork shareManager];
    
    [networking GET:[QGDepositRequestApi urlWithIndex:QGCardRequestServerMethodGetAccess] parameters:nil success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary *data = responseObject[@"data"];
            NSInteger errorCount = [data[@"errorCount"] integerValue];
            NSInteger totalCount = [data[@"totalCount"] integerValue];
            NSString *forgetURL = data[@"tradePwdForgetH5Url"];
            self.forgetURL = forgetURL;
            self.errorCount = errorCount;
            self.totalCount = totalCount;
            if (errorCount < totalCount) {
                [self showPwdInputView];
            }else{
                ///密码已经超限
                [self showPwdNotAvailableView];
            }
        }else{
            [QGHUDManager showHud:responseObject[@"msg"] ? responseObject[@"msg"] :@"内部错误,请稍后再试"];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager hideHud];
        QGAlertView *alert = [[QGAlertView alloc]initWithTitle:@"提示" message:@"网络错误" cancelButtonTitle:@"取消" sureButtonTitle:@"重试" clickBlock:^(NSInteger index) {
            if (index == 1) {
                [self queryPwdAvailable];
            }
        }];
        [alert showInView:nil];
    }];
}

- (void)showPwdNotAvailableView
{
    [QGHUDManager hideHud];
    QGAlertView *alert = [[QGAlertView alloc]initWithTitle:nil message:@"密码错误5次，请明天再试" cancelButtonTitle:nil sureButtonTitle:@"知道了" clickBlock:^(NSInteger index) {
        
    }];
    [alert showInView:self.superView];
}

- (void)showPwdInputView
{
    [QGHUDManager hideHud];
    QGDepositPwdView *pwdView = [[QGDepositPwdView alloc]init];
    pwdView.type = self.type;
    pwdView.amount = self.amount;
    pwdView.card = self.card;
    pwdView.forgetURL = self.forgetURL;
    /// 赋值结果回调
    self.resultBlock = pwdView.resultBlock;
    [pwdView showInView:self.superView];
    
    self.pwdView = pwdView;
    
    @weakify(self);
    pwdView.inputPwdCompleteBlock = ^(NSString * _Nonnull pwd) {
        @strongify(self);
        /// 获取密码加密盐值
        [self getSaltComplete:^(NSString *salt) {
            /// 对密码进行DES加密
            NSString *encryptPwd = [NSString encryptUseDES:pwd key:salt];
            /// 校验交易密码
            if (self.type == QGDepositTypeRepay) {
                ///还款交易
                [self verifyPaymentWithEncryPwd:encryptPwd];
            }else{
                /// 转入转出交易
                [self verifyTradeWithEncryptPwd:encryptPwd];
            }
        }];
    };
}

/// 获取加密盐值
- (void)getSaltComplete:(void(^)(NSString *salt))complete
{
    QGTalosNetwork *networking = [QGTalosNetwork shareManager];
    [QGHUDManager showHud:@""];
    [networking GET:[QGDepositRequestApi urlWithIndex:QGCardRequestServerMethodGetSalt] parameters:nil success:^(id  _Nonnull responseObject) {
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary *data = responseObject[@"data"];
            NSString *salt = data[@"payPwdSalt"];
            if (complete) {
                complete(salt);
            }
        }else{
            [QGHUDManager showHud:@"数据加密异常"];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:@"网络错误"];
    }];
}

#pragma mark - 享花卡还款交易

-(void)verifyPaymentWithEncryPwd:(NSString *)pwd
{
    QGTalosNetwork *networking = [QGTalosNetwork shareManager];
    NSMutableDictionary *param = [NSMutableDictionary dictionary];
    
    [param setObject:self.card.cardId forKey:@"cardId"];
    [param setObject:pwd forKey:@"encryptPwd"];
    [param setObject:self.card.bankName forKey:@"bankCardName"];
    [param setObject:self.card.billNumber forKey:@"billNumber"];
    [param setObject:@(self.card.isLowestRepay) forKey:@"isLowestRepay"];
    [param setObject:@(self.card.isPreRepay) forKey:@"isPreRepay"];
    [param setObject:self.card.tailCardNo forKey:@"bankCardNo"];
    
   // [QGRepaymentReuestApi urlWithIndex:QGRepaymentRequestServerMethodRepay]
    //@"http://yapi.quantgroups.com/mock/305/vcc/encrypt_repay"
    [networking POST:[QGRepaymentReuestApi urlWithIndex:QGRepaymentRequestServerMethodEncryptRepay] parameters:param success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            if (self.tradeResultBlock) {
                self.tradeResultBlock(YES, nil, nil);
            }
            
            if (self.resultBlock) {
                self.resultBlock(QGDepositResultTypeSuccess, nil);
            }
        }else{
            /// 失败信息
            NSString *message = responseObject[@"msg"] ? responseObject[@"msg"] :@"未知错误,交易失败";
            /// 回调:交易失败
            if (self.tradeResultBlock) {
                self.tradeResultBlock(NO, nil,message);
            }
            
            [self handleRepayFailureWithResponse:responseObject];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
       [QGHUDManager showHud:@"网络错误,交易失败"];
    }];
}

#pragma mark - 转入转出交易
/// 验证交易密码
- (void)verifyTradeWithEncryptPwd:(NSString *)pwd
{
    QGTalosNetwork *networking = [QGTalosNetwork shareManager];
    
    NSMutableDictionary *param = [NSMutableDictionary dictionary];
    [param setObject:pwd forKey:@"pwd"];
    [param setObject:self.amount forKey:@"amount"];
    [param setObject:@(self.type) forKey:@"flag"];
    long reqId = [[NSDate date] timeIntervalSince1970] * 1000;
    [param setObject:[NSString stringWithFormat:@"%ld",reqId] forKey:@"reqId"];
    NSLog(@"--------------- 交易数据开始");
    [networking POST:[QGDepositRequestApi urlWithIndex:QGCardRequestServerMethodInout] parameters:param success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary *data = responseObject[@"data"];
            NSString *tradeNo = data[@"tradeNo"];
            ///交易成功
            if (self.tradeResultBlock) {
                self.tradeResultBlock(YES, tradeNo,nil);
            }
            
            ///上报交易结果
            if (self.resultBlock) {
                self.resultBlock(QGDepositResultTypeSuccess, nil);
            }
            
        }else{
            /// 失败信息
            NSString *message = responseObject[@"msg"] ? responseObject[@"msg"] :@"未知错误,交易失败";
            /// 回调:交易失败
            if (self.tradeResultBlock) {
                self.tradeResultBlock(NO, nil,message);
            }
            
            [self handleTradeFailureWithResponse:responseObject];
 
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:@"网络错误,交易失败"];
    }];
}

- (void)handleRepayFailureWithResponse:(NSDictionary *)responseObject
{
    NSString *bussinessCode = [NSString stringWithFormat:@"%@",responseObject[@"businessCode"]];
    if ([bussinessCode integerValue] == 2) {
        self.errorCount ++;
        /// 超过次数
        if (self.errorCount >= self.totalCount) {
            if (self.resultBlock) {
                self.resultBlock(QGDepositResultTypeFailure, @"密码错误次数过多");
            }
            [self showPwdNotAvailableView];
        }else{
            NSString *message = [NSString stringWithFormat:@"密码错误%lu次,还剩%lu次尝试",self.errorCount,self.totalCount - self.errorCount];
            if (self.resultBlock) {
                self.resultBlock(QGDepositResultTypeFailureForPwd, message);
            }
        }
    }else{
        NSString *message = responseObject[@"msg"];
        [QGHUDManager showHud:message?message:@"未知错误,交易失败"];
        if (self.resultBlock) {
            self.resultBlock(QGDepositResultTypeFailure, nil);
        }
    }
}

///BIZ_CODE_DEBIT_REQ_ERROR(3101L,"请求入参错误，请确认后重试")
///BIZ_CODE_DEBIT_QUICK_ERROR(3102L, "同一用户连续请求多次")
///BIZ_CODE_DEBIT_USER_ERROR(3103L, "该用户尚未开通储蓄卡")
///BIZ_CODE_DEBIT_NOT_BIND_CARD(3104L, "该用户尚未绑定银行卡"), 
///BIZ_CODE_DEBIT_NOT_PAY_PWD(3105L, "该用户尚未设置交易密码"), 
///BIZ_CODE_DEBIT_PAY_PWD_ERROR(3106L, "该用户交易密码不正确"), 
///BIZ_CODE_DEBIT_AMOUNT_ERROR(3107L, "该用户交易金额不正确"), 
///BIZ_CODE_DEBIT_TRADE_ERROR(3108L, "该用户存在尚未完成的交易记录"),
- (void)handleTradeFailureWithResponse:(NSDictionary *)responseObject
{
    NSString *bussinessCode = [NSString stringWithFormat:@"%@",responseObject[@"businessCode"]];
    /// 处理密码错误
    if ([bussinessCode isEqualToString:@"3106"]) {
        self.errorCount ++;
        /// 超过次数
        if (self.errorCount >= self.totalCount) {
            if (self.resultBlock) {
                self.resultBlock(QGDepositResultTypeFailure, @"密码错误次数过多");
            }
            [self showPwdNotAvailableView];
        }else{
            NSString *message = [NSString stringWithFormat:@"密码错误%lu次,还剩%lu次尝试",self.errorCount,self.totalCount - self.errorCount];
            if (self.resultBlock) {
                self.resultBlock(QGDepositResultTypeFailureForPwd, message);
            }
        }
    }else if ([bussinessCode isEqualToString:@"3107"]){
        [QGHUDManager showHud:@"交易金额有误"];
        if (self.resultBlock) {
            self.resultBlock(QGDepositResultTypeFailure, nil);
        }
    }else{
        NSString *message = responseObject[@"msg"];
        [QGHUDManager showHud:message?message:@"未知错误,交易失败"];
        if (self.resultBlock) {
            self.resultBlock(QGDepositResultTypeFailure, nil);
        }
    }
}


@end
