//
//  QGDepositeRecordedViewController.m
//  VirtualPayment
//
//  Created by silicn on 2020/4/1.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGDepositeRecordedViewController.h"
#import "QGDepositResultViewController.h"

#import "QGDepositeHeaderView.h"

#import "QGDepositeAmountViewCell.h"
#import "QGDepositeBankViewCell.h"

#import "QGGradientShadowButton.h"

#import "QGDepositPwdView.h"
#import "QGAlertView.h"
#import "QGDepositeCardModel.h"

#import "QGDepositPwdManager.h"

#import "QGDepositRequestApi.h"


@interface QGDepositeRecordedViewController ()<UITableViewDelegate,UITableViewDataSource>



@property (nonatomic, strong) UITableView *tableView ;

@property (nonatomic, strong) QGDepositeHeaderView *headerView ;

/// 确认按钮
@property (nonatomic, strong) QGGradientShadowButton *commitBtn ;

/// 说明:
/// 转入 type = 1:一类户(储蓄卡) -> 二类户(享花卡)
/// 转出 type = 2:二类户(享花卡) -> 一类户(储蓄卡)

/// 1代表转入 2代表转出
@property (nonatomic, assign) NSInteger type;
/// 以下两个model需要获取数据时根据type自动转换赋值
/// 转出卡
@property (nonatomic, strong) QGDepositeCardModel *fromModel ;
/// 转入卡
@property (nonatomic, strong) QGDepositeCardModel *toModel;


/// 交易单号
@property (nonatomic, copy) NSString *tradeNo ;

/// 转入转出记录跳转URL
@property (nonatomic, copy) NSString *recordURL ;

/// 忘记密码URL
@property (nonatomic, copy) NSString *forgetPwdURL ;

/// 输入的金额
@property (nonatomic, copy) NSString *amount;

@property (nonatomic, strong) QGDepositeAmountViewCell *amountCell ;

@property (nonatomic, strong) UIView *editView ;

@end

@implementation QGDepositeRecordedViewController

- (BOOL)checkParameters:(NSDictionary *)param
{
    if (param[@"type"] && [param[@"type"] intValue] != 0) {
        return YES;
    }
    return NO;
}

- (void)transferParameters:(NSDictionary *)param
{
    self.type = [param[@"type"] integerValue];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setupNavigation];
    
    [self initNomalUI];

    [self requestData];
    
    // Do any additional setup after loading the view.
}

- (void)setupNavigation
{
    [self custemLeftDefaultBarButtonItem];
    [self setNavBarBottomLineHidden:YES];
    self.title = self.type == 1 ? @"转入" :@"转出";
    @weakify(self);
    [self custemRightBarButtonItemWithTitle:self.type == 1 ? @"转入记录" :@"转出记录" imageName:nil action:^(UIButton * _Nonnull button) {
        @strongify(self);
        [self navigationToWeb:self.recordURL];
        [self analyticsHis];
    }];
}


- (void)initNomalUI
{
    self.view.backgroundColor = [UIColor moduleSeparatorColorF7F7];
    
    /// tableView
     self.tableView = [[UITableView alloc]initWithFrame:CGRectZero style:UITableViewStyleGrouped];
     _tableView.delegate = self;
     _tableView.dataSource = self;
     [self.view addSubview:_tableView];
     _tableView.backgroundColor = UIColor.moduleSeparatorColorF7F7;
     _tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
     _tableView.estimatedRowHeight = 60;
     _tableView.rowHeight = 60;
     
    [self.tableView mas_makeConstraints:^(MASConstraintMaker *make) {
         make.left.right.bottom.equalTo(self.view);
         if (@available(iOS 11.0, *)) {
             make.top.equalTo(self.view.mas_safeAreaLayoutGuideTop);
         } else {
             make.top.equalTo(self.view.mas_top).inset(64);
         }
     }];
    
    /// 银行卡信息
    QGDepositeHeaderView *headerView = [[QGDepositeHeaderView alloc]initWithFrame:CGRectMake(0, 0, self.view.frame.size.width, 172)];
    self.tableView.tableHeaderView = headerView;
    self.headerView = headerView;
    self.headerView.type = self.type == 1 ? QGDepositTypeIn : QGDepositTypeOut;
    
    /// 转入转出按钮
    UIView *footerView = [UIView creatViewWithSuperView:nil backgroundColor:UIColor.clearColor];
    footerView.frame = CGRectMake(0, 0, self.view.frame.size.width, 130);
    self.tableView.tableFooterView = footerView;
    
    QGGradientShadowButton *commitBtn = [QGGradientShadowButton creatGradientColorButtonWithSuperView:footerView title:@"转入" textFont:[UIFont qg_regularFontOfSize:17.0f]];
    [commitBtn setTitle:self.type == 1 ? @"转入":@"转出" forState:UIControlStateNormal];
    self.commitBtn = commitBtn;
    [commitBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.inset(20);
        make.top.inset(65);
        make.height.mas_equalTo(40);
    }];
    
    [commitBtn addTarget:self action:@selector(commitAction:) forControlEvents:UIControlEventTouchUpInside];
    
    /// 主要就是为了下落键盘
      [self.view addSubview:self.editView];
      [self.editView mas_makeConstraints:^(MASConstraintMaker *make) {
          make.edges.equalTo(self.view);
      }];
}

- (void)refreshHeaderView
{
    self.headerView.fromModel = self.fromModel;
    self.headerView.toModel = self.toModel;
}



#pragma mark - 确认转入|转出 ->查询密码次数 ->校验密码

- (void)commitAction:(UIButton *)btn
{
    /// 下落键盘
    [self.view endEditing:YES];
    /// 取金额
    self.amount = self.amountCell.amountTF.text;
    
    /// 金额为空
    if (self.amount == nil || [self.amount isEqualToString:@""]) {
        QGAlertView *alert = [[QGAlertView alloc]initWithTitle:nil message:@"请输入转账金额" cancelButtonTitle:nil sureButtonTitle:@"知道了" clickBlock:NULL];
        [alert showInView:self.view];
        return;
    }
    /// 金额有误
    if ([self.amount floatValue] > [self.fromModel.maxAmount floatValue] || [self.amount floatValue] < [self.fromModel.minAmount floatValue]) {
        return;
    }
    
    QGDepositPwdManager *manager = [QGDepositPwdManager shareManager];
    manager.type = self.type == 1 ? QGDepositTypeIn : QGDepositTypeOut;
    manager.amount = self.amount;
    manager.card = self.fromModel;
    [manager showInView:self.view];
    
    /// 获取交易结果
    @weakify(self);
    manager.tradeResultBlock = ^(BOOL success, NSString * _Nullable tradeNo,NSString * _Nullable message) {
        @strongify(self);
        if (success) {
            self.tradeNo = tradeNo;
            [self toTradeResult];
        }
    };
    
}


/// 交易结果页面
- (void)toTradeResult
{
    QGDepositResultViewController *vc = [[QGDepositResultViewController alloc]init];
    vc.tradeNo = self.tradeNo;
    vc.type = self.type == 1 ? QGDepositTypeIn :QGDepositTypeOut;
    vc.recordURL = self.recordURL;
    @weakify(self);
    /// 再转一笔|重新转账 点击事件
    vc.actionBlock = ^(QGDepositResultViewType viewType) {
        @strongify(self);
        if (viewType == QGDepositResultViewTypeSuccess) {
            self.amount = nil;
            [self.tableView reloadData];
        }
    };
    [self.navigationController pushViewController:vc animated:YES];
}


#pragma mark - Request

/// 获取交易基础信息
- (void)requestData
{
    QGTalosNetwork *netWork = [QGTalosNetwork shareManager];
    [QGHUDManager showHud:nil];
    [netWork GET:[QGDepositRequestApi urlWithIndex:QGCardRequestServerMethodDepositInfo] parameters:nil success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
           
            NSDictionary *data = responseObject[@"data"];
            NSDictionary *bankInfo = data[@"bankInfo"];
            QGDepositeCardModel * bankModel = [QGDepositeCardModel yy_modelWithJSON:bankInfo];
            NSDictionary *eCardInfo = data[@"eCardInfo"];
            QGDepositeCardModel * eCardModel = [QGDepositeCardModel yy_modelWithJSON:eCardInfo];
            /// 处理转入还是转出
            [self handleTypeWithBankMode:bankModel eCardModel:eCardModel];
            /// 转账记录
            self.recordURL = data[@"jumpUrl"];
            ///忘记密码
            self.forgetPwdURL = data[@"forgetUrl"];
            
            [self.commitBtn setGradientButtonIsClickEnabled:YES];
            [self.tableView reloadData];
            [self refreshHeaderView];
            
        }else{
            [self.commitBtn setGradientButtonIsClickEnabled:NO];
            [QGHUDManager showHud:responseObject[@"msg"] ? responseObject[@"msg"] :@"获取信息错误"];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
         [QGHUDManager hideHud];
        @weakify(self);
        QGDefaultView * view = [QGDefaultView defaultViewShowWithSuperView:self.view reloadBlock:^{
            @strongify(self);
            [self requestData];
        }];
        view.viewType = QGDefaultViewTypeBadNetwork;
    }];
}


/// 处理转入转出model逻辑
/// @param bankModel 一类户
/// @param eCardModel 二类户
- (void)handleTypeWithBankMode:(QGDepositeCardModel *)bankModel eCardModel:(QGDepositeCardModel *)eCardModel
{
    if (self.type == 1) { /// 转入逻辑
        self.fromModel = bankModel;
        self.toModel = eCardModel;
        
        if ([self.fromModel.maxAmount floatValue] == 0) {
            QGAlertView *alert = [[QGAlertView alloc]initWithTitle:nil message:@"绑卡银行不支持入金，请通过绑卡银行手机银行转账转入" cancelButtonTitle:nil sureButtonTitle:@"知道了" clickBlock:NULL];
            [alert showInView:self.view];
        }
        
    }else if (self.type == 2){ /// 转出逻辑
        self.fromModel = eCardModel;
        self.toModel = bankModel;
    }
}


#pragma mark - TableView Delegate & DataSource

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    UIView *view = [[UIView alloc]initWithFrame:CGRectMake(0, 0, self.view.frame.size.width, 10)];
    view.backgroundColor = UIColor.moduleSeparatorColorF7F7;
    return view;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 10.0f;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 2;
}

// Row display. Implementers should *always* try to reuse cells by setting each cell's reuseIdentifier and querying for available reusable cells with dequeueReusableCellWithIdentifier:
// Cell gets various attributes set automatically based on table (separators) and data source (accessory views, editing controls)

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.row == 0) {
        QGDepositeAmountViewCell *cell =  (QGDepositeAmountViewCell *)[self getCellFromClassName:NSStringFromClass([QGDepositeAmountViewCell class]) dequeueTableView:tableView];
        cell.model = self.fromModel;
        cell.amountTF.text = self.amount;
        cell.amountTF.placeholder = self.type == 1 ? @"请输入转入金额":@"请输入转出金额";
        @weakify(self);
        cell.amountEditBlock = ^(BOOL valid, NSString * _Nonnull amount) {
            @strongify(self);
            [self amountDidEditEndWithValid:valid amount:amount];
        };
        /// 开始编辑
        cell.editBeginBlock = ^{
            @strongify(self);
            self.editView.hidden = NO;
        };
        self.amountCell = cell;
        return cell;
    }
    QGDepositeBankViewCell *cell =  (QGDepositeBankViewCell *)[self getCellFromClassName:NSStringFromClass([QGDepositeBankViewCell class]) dequeueTableView:tableView];
    QGDepositeCardModel *model = self.fromModel;
    if (model) {
        cell.subTextLab.text = [NSString stringWithFormat:@"%@ %@(%@)",model.bankName ? model.bankName :@"",model.type?model.type:@"",model.tailCardNo?model.tailCardNo:@""];
    }else{
        cell.subTextLab.text = @"";
    }
    
    return cell;
}


/// 输入金额的有效性回调
/// @param valid 是否有效
/// @param amount 金额
- (void)amountDidEditEndWithValid:(BOOL)valid amount:(NSString *)amount
{
    [self.commitBtn setGradientButtonIsClickEnabled:valid];
}



- (void)scrollViewWillBeginDragging:(UIScrollView *)scrollView
{
    [self.view endEditing:YES];
}

- (UIView *)editView
{
    if (_editView == nil) {
        _editView = [[UIView alloc]init];
        _editView.backgroundColor = UIColor.clearColor;
        _editView.hidden = YES;
        UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(dissmissKeyboard)];
        [_editView addGestureRecognizer:tap];
    }
    return _editView;
}


/// 下落键盘
- (void)dissmissKeyboard
{
    _editView.hidden = YES;
    [self.view endEditing:YES];
}


/// 埋点转账记录
- (void)analyticsHis
{
    QGAppCoreModelClickEvent *event = [QGAppCoreModelClickEvent acmcEventWithPage:@"转入转出页面" path:@"转入/出记录" name:@"转入/出记录" detail_name:@"转入/出明细"];
    [QGAnalyticsService analyticsTrackWithEvent:event];
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
