//
//  QGDepositResultViewController.m
//  VirtualPayment
//
//  Created by silicn on 2020/4/1.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGDepositResultViewController.h"

#import "QGDepositRequestApi.h"

#import "QGCountDown.h"

@interface QGDepositResultViewController ()

/// 图片
@property (nonatomic, strong)UIImageView *imageView;
/// 时间
@property (nonatomic, strong)UILabel *timeLab;
/// 主提示
@property (nonatomic, strong)UILabel *titleLab;
/// 副提示
@property (nonatomic, strong)UILabel *subTitleLab ;
/// 再转一笔
@property (nonatomic, strong) UIButton *depositBtn ;
/// 返回首页
@property (nonatomic, strong) UIButton *homeBtn ;
/// 计时器
@property (nonatomic, strong) QGCountDown *timer ;
/// 秒数
@property (nonatomic, assign)NSInteger seconds;
/// 页面样式
@property (nonatomic, assign)QGDepositResultViewType viewType;
/// 转账失败错误信息
@property (nonatomic, copy)NSString *errorMsg;



@end

@implementation QGDepositResultViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.viewType = QGDepositResultViewTypeNone;
    
    [self setupNavigation];
    
    [self initNomalUI];
    
    [self initData];
    
    // Do any additional setup after loading the view.
}

- (void)setupNavigation
{
    [self custemLeftDefaultBarButtonItem];
    [self setNavBarBottomLineHidden:YES];
    self.title = self.type == QGDepositTypeIn ? @"转入" :@"转出";
}

- (void)initNomalUI
{
    /// 图片
    UIImageView *imageView = [[UIImageView alloc]init];
    [self.view addSubview:imageView];
    NSArray *images = [self getImages];
    imageView.image = [images firstObject];
    imageView.animationImages = images;
    imageView.animationDuration = 1.0f;
    [imageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.height.width.mas_equalTo(120);
        if (@available(iOS 11.0, *)) {
            make.top.equalTo(self.view.mas_safeAreaLayoutGuideTop).inset(40);
        } else {
            make.top.equalTo(self.view.mas_top).inset(104);
        }
    }];
    self.imageView = imageView;
    [imageView startAnimating];
    /// 时间倒计时
    UILabel *timeLab = [UILabel creatLabelWithSuperView:self.view title:@"15s" titleFontSize:[UIFont qg_mediumFontOfSize:15.0f] textColor:UIColor.yyMainThemeColor alignment:NSTextAlignmentCenter];
    [timeLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.centerY.equalTo(self.imageView);
        make.height.width.mas_equalTo(40);
    }];
    self.timeLab  = timeLab;
    /// 正在转入/出
    NSString *title = self.type == QGDepositTypeIn ?@"正在转入，请耐心等待…":@"正在转出，请耐心等待…";
    UILabel *titleLab = [UILabel creatLabelWithSuperView:self.view title:title titleFontSize:[UIFont qg_regularFontOfSize:16.0f] textColor:UIColor.textColor3333 alignment:NSTextAlignmentCenter];
    [titleLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(imageView.mas_bottom).offset(20);
        make.centerX.equalTo(imageView);
    }];
    self.titleLab = titleLab;
    ///温馨提示
    UILabel *subTitleLab = [UILabel creatLabelWithSuperView:self.view title:@"温馨提示：交易结果返回前，请不要重复提交" titleFontSize:[UIFont qg_lightFontOfSize:12.0f] textColor:UIColor.textColor9999 alignment:NSTextAlignmentCenter];
    subTitleLab.numberOfLines = 0;
    [subTitleLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(titleLab.mas_bottom).offset(6);
        make.centerX.equalTo(titleLab);
        make.left.right.greaterThanOrEqualTo(self.view).inset(25);
    }];
    self.subTitleLab = subTitleLab;
    
    /// 再转一笔
    self.depositBtn = [UIButton creatButtonWithSuperView:self.view title:@"" titleFont:[UIFont qg_regularFontOfSize:17.0] textColor:UIColor.yyMainThemeColor];
    _depositBtn.layer.cornerRadius = 20;
    _depositBtn.layer.borderColor = UIColor.yyMainThemeColor.CGColor;
    _depositBtn.layer.borderWidth = 1;
    _depositBtn.layer.masksToBounds = YES;
    _depositBtn.hidden = YES;
    [_depositBtn addTarget:self action:@selector(depositBtnAction:) forControlEvents:UIControlEventTouchUpInside];
    
    [self.depositBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.inset(20);
        make.top.equalTo(self.subTitleLab.mas_bottom).offset(50);
        make.height.mas_equalTo(40);
    }];
    /// 返回首页
    self.homeBtn = [UIButton creatButtonWithSuperView:self.view title:@"返回首页" titleFont:[UIFont qg_regularFontOfSize:17.0] textColor:UIColor.whiteColor];
    _homeBtn.backgroundColor = UIColor.yyMainThemeColor;
    _homeBtn.layer.cornerRadius = 20;
    _homeBtn.clipsToBounds = YES;
    _homeBtn.hidden = YES;
    [_homeBtn addTarget:self action:@selector(homeBtnAction:) forControlEvents:UIControlEventTouchUpInside];
    
    [self.homeBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.subTitleLab.mas_bottom).offset(105);
        make.left.right.inset(20);
        make.height.mas_equalTo(40);
    }];
   
}

/// 初始化数据
- (void)initData
{
    self.seconds = 15;
    self.timer = [[QGCountDown alloc]init];
    @weakify(self);
    
    [self.timer countDownWithSEC:1.0f isImmediatelySelector:YES eventBlock:^{
        @strongify(self);
        /// 时间间隔
        static NSInteger interval = 0;
        self.seconds--;
        interval++;
        self.timeLab.text = [NSString stringWithFormat:@"%lus",self.seconds];
        if (self.seconds == 0) {
            [self stopTimer];
            self.viewType = QGDepositResultViewTypeWaiting;
        }
        /// 三秒刷新一次接口
        if (interval == 3 && self.seconds != 0) {
            [self queryResult];
            interval = 0;
        }
    }];
}


///成功/失败/处理中,交易状态 0-处理中 1-成功 2-失败
/// 查询交易结果
- (void)queryResult
{
    if (self.tradeNo == nil) {
        return;
    }
    
    QGTalosNetwork *networking = [QGTalosNetwork shareManager];
    NSMutableDictionary *param = [NSMutableDictionary dictionary];
    [param setObject:self.tradeNo forKey:@"tradeNo"];
    [networking GET:[QGDepositRequestApi urlWithIndex:QGCardRequestServerMethodGetResult] parameters:param success:^(id  _Nonnull responseObject) {
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary *data = responseObject[@"data"];
            NSInteger status = [data[@"status"] integerValue];
            /// 仅处理成功和失败, status=0 在计时seconds=15的逻辑里
            if (status == 1) {
                [self stopTimer];
                self.viewType = QGDepositResultViewTypeSuccess;
            }else if (status == 2){
                [self stopTimer];
                self.errorMsg = data[@"remark"];
                self.viewType = QGDepositResultViewTypeFailure;
                
            }
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        
    }];
}

/// 停止计时,并且终止Gif动画
- (void)stopTimer
{
    [self.timer destoryTimer];
    [self.imageView stopAnimating];
    self.imageView.animationImages = nil;
}

- (void)setViewType:(QGDepositResultViewType)viewType
{
    if (_viewType != viewType) {
        _viewType = viewType;
        [self refreshViewWithType:viewType];
    }
}

#pragma mark - 切换页面样式
/// 切换页面样式
- (void)refreshViewWithType:(QGDepositResultViewType)type
{
    switch (type) {
        case QGDepositResultViewTypeNone:
        {
            self.depositBtn.hidden = YES;
            self.homeBtn.hidden = YES;
        }
            break;
        case QGDepositResultViewTypeSuccess: /// 转账成功
        {
            self.timeLab.hidden = YES;
            self.imageView.image = [UIImage imageNamed:@"deposit_success"];
            self.subTitleLab.text = @"预计10秒钟到账，请稍后…";
            if (self.type == QGDepositTypeIn) {
                self.depositBtn.hidden = self.homeBtn.hidden = NO;
                self.titleLab.text = @"转入成功";
            }else{
                self.titleLab.text = @"转出成功";
                self.depositBtn.hidden = YES;
                self.homeBtn.hidden = NO;
            }
            [self.depositBtn setTitle:@"再转一笔" forState:UIControlStateNormal];
            [self.homeBtn setTitle:@"完成" forState:UIControlStateNormal];
            [self addHistoryBtn];
        }
            break;
        case QGDepositResultViewTypeFailure: /// 转账失败
        {
            self.timeLab.hidden = YES;
            self.imageView.image = [UIImage imageNamed:@"deposit_failure"];
            self.titleLab.text = self.type == QGDepositTypeIn ?@"转入失败":@"转出失败";
            self.depositBtn.hidden = self.homeBtn.hidden = NO;
            [self.depositBtn setTitle:@"重新转账" forState:UIControlStateNormal];
            [self.homeBtn setTitle:@"返回首页" forState:UIControlStateNormal];
        }
            break;
        case QGDepositResultViewTypeWaiting: /// 正在转账
        {
            self.timeLab.hidden = YES;
            self.imageView.image = [UIImage imageNamed:@"deposit_wait"];
            self.titleLab.text = self.type == QGDepositTypeIn ? @"正在转入":@"正在转出";
            self.subTitleLab.text = @"请从转入转出记录中查看交易结果";
            self.depositBtn.hidden = !(self.homeBtn.hidden = NO);
            [self.homeBtn setTitle:@"返回首页" forState:UIControlStateNormal];
        }
            break;
            
        default:
            break;
    }
}

- (void)setErrorMsg:(NSString *)errorMsg
{
    if (_errorMsg != errorMsg) {
        _errorMsg = errorMsg;
        self.subTitleLab.text = errorMsg;
    }
}

/// 转账成功时增加历史转账按钮
- (void)addHistoryBtn
{
    [self.subTitleLab mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.titleLab.mas_bottom).offset(6);
        make.centerX.equalTo(self.titleLab).offset(-35);
    }];
    
    NSString *title = self.type == QGDepositTypeIn ? @"转入记录>>":@"转出记录>>";
    UIButton *historyBtn = [UIButton creatButtonWithSuperView:self.view title:title titleFont:[UIFont qg_regularFontOfSize:12.0f] textColor:UIColor.yyMainThemeColor];
    [historyBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.subTitleLab.mas_right).offset(5);
        make.centerY.equalTo(self.subTitleLab);
    }];
    
    [historyBtn addTarget:self action:@selector(toHistory) forControlEvents:UIControlEventTouchUpInside];
}

#pragma mark - 自定义方法

/// 转账记录
- (void)toHistory
{
    [self navigationToWeb:self.recordURL];
}

/// 再转一笔|重新转账
- (void)depositBtnAction:(UIButton *)btn
{
    if (self.actionBlock) {
        self.actionBlock(self.viewType);
    }
    [self.navigationController popViewControllerAnimated:YES];
    if (self.viewType == QGDepositResultViewTypeSuccess) {
        QGAppCoreModelClickEvent *event = [QGAppCoreModelClickEvent acmcEventWithPage:@"转入转出结果页" path:@"转入/出结果" name:@"转入/出成功" detail_name:@"再转一笔"];
        [QGAnalyticsService analyticsTrackWithEvent:event];
    }else if (self.viewType == QGDepositResultViewTypeFailure){
        QGAppCoreModelClickEvent *event = [QGAppCoreModelClickEvent acmcEventWithPage:@"转入转出结果页" path:@"转入/出结果" name:@"转入/出失败" detail_name:@"重新转账"];
        [QGAnalyticsService analyticsTrackWithEvent:event];
    }
}

/// 返回首页|完成
- (void)homeBtnAction:(UIButton *)btn
{
    [self.navigationController popToRootViewControllerAnimated:YES];
    if (self.viewType == QGDepositResultViewTypeSuccess) {
        QGAppCoreModelClickEvent *event = [QGAppCoreModelClickEvent acmcEventWithPage:@"转入转出结果页" path:@"转入/出结果" name:@"转入/出成功" detail_name:@"完成"];
        [QGAnalyticsService analyticsTrackWithEvent:event];
    }else if (self.viewType == QGDepositResultViewTypeFailure){
        QGAppCoreModelClickEvent *event = [QGAppCoreModelClickEvent acmcEventWithPage:@"转入转出结果页" path:@"转入/出结果" name:@"转入/出失败" detail_name:@"回到首页"];
        [QGAnalyticsService analyticsTrackWithEvent:event];
    }
}


- (NSArray *)getImages
{
    NSURL *gifImageUrl = [[NSBundle mainBundle] URLForResource:@"count_down" withExtension:@"gif"];
    //获取Gif图的原数据
    CGImageSourceRef gifSource = CGImageSourceCreateWithURL((CFURLRef)gifImageUrl, NULL);
     //获取Gif图有多少帧
    size_t gifcount = CGImageSourceGetCount(gifSource);
    NSMutableArray *images = [[NSMutableArray alloc] init];

    for (NSInteger i = 0; i < gifcount; i++) {
        CGImageRef imageRef = CGImageSourceCreateImageAtIndex(gifSource, i, NULL);
        UIImage *image = [UIImage imageWithCGImage:imageRef];
        [images addObject:image];
        CGImageRelease(imageRef);
    }
    return images;
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
