//
//  QGCreditApplyHeaderCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/4/1.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGCreditApplyHeaderCell.h"
#import "QGBasicUITool.h"
#import "QGGradientView.h"
@implementation QGCreditApplyHeaderCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        //底部渐变色
        QGGradientView * gradientContentView = [[QGGradientView alloc] init];
        [self.contentView addSubview:gradientContentView];
        
        [gradientContentView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.top.right.bottom.inset(0);
        }];
        
        //标题
        UILabel * titleLabel = [UILabel creatLabelWithSuperView:gradientContentView title:@"可申请额度" titleFontSize:[UIFont qg_lightFontOfSize:12] textColor:[UIColor whiteColor] alignment:NSTextAlignmentCenter];
        [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerX.offset(0);
            make.top.inset(30);
            make.height.mas_equalTo(17);
        }];
        
        //最高额度
        UILabel * amountLabel = [UILabel creatLabelWithSuperView:gradientContentView title:@"最高50,000元" titleFontSize:[UIFont qg_numberFontOfSize:30] textColor:[UIColor whiteColor] alignment:NSTextAlignmentCenter];
        [amountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerX.offset(0);
            make.top.mas_equalTo(titleLabel.mas_bottom).offset(5);
            make.height.mas_equalTo(42);
        }];
        
        //子标题
        UILabel * subTitleLabel = [UILabel creatLabelWithSuperView:gradientContentView title:@"实际额度，以最终审批为主" titleFontSize:[UIFont qg_lightFontOfSize:12] textColor:[UIColor whiteColor] alignment:NSTextAlignmentCenter];
        [subTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerX.offset(0);
            make.top.mas_equalTo(amountLabel.mas_bottom).offset(15);
            make.height.mas_equalTo(17);
        }];
        
        //分割线
        UIView * lineView = [UIView creatViewWithSuperView:gradientContentView backgroundColor:[UIColor whiteColor]];
        [lineView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(15);
            make.top.mas_equalTo(subTitleLabel.mas_bottom).offset(41);
            make.height.mas_equalTo(0.5);
        }];
        
        //左侧描述
        UILabel * leftDescLabel = [UILabel creatLabelWithSuperView:gradientContentView title:@"秒出额度" titleFontSize:[UIFont qg_lightFontOfSize:14] textColor:[UIColor whiteColor] alignment:NSTextAlignmentCenter];
        [leftDescLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(15);
            make.top.mas_equalTo(lineView.mas_bottom).offset(15);
            make.height.mas_equalTo(20);
        }];
        
        //中间描述
        UILabel * centerDescLabel = [UILabel creatLabelWithSuperView:gradientContentView title:@"随借随还" titleFontSize:leftDescLabel.font textColor:leftDescLabel.textColor alignment:leftDescLabel.textAlignment];
        [centerDescLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerX.offset(0);
            make.top.height.mas_equalTo(leftDescLabel);
        }];
        
        //右侧描述
        UILabel * rightDescLabel = [UILabel creatLabelWithSuperView:gradientContentView title:@"循环额度" titleFontSize:leftDescLabel.font textColor:leftDescLabel.textColor alignment:leftDescLabel.textAlignment];
        [rightDescLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(15);
            make.top.height.mas_equalTo(leftDescLabel);
        }];
        
    }
    return self;
}

@end
