//
//  QGCardNotificationController.m
//  VirtualPayment
//
//  Created by 张博 on 2019/12/31.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGCardNotificationController.h"
#import "QGCardHomeModel.h"
#import "QGCardNotificationContentCell.h"
#import "QGMembershipCenterDataModel.h"
@interface QGCardNotificationController ()

/// 公告模型
@property (nonatomic, strong) QGNotifyInfoModel * infoModel;


@end


@implementation QGCardNotificationController


- (BOOL)checkParameters:(NSDictionary *)param
{
    if (param[@"infoModel"]) {
        return YES;
    }
    return NO;
}

- (void)transferParameters:(NSDictionary *)param
{
    if (param[@"infoModel"]) {
        self.infoModel = param[@"infoModel"];
    }
}


- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    self.title = @"详情";
    [self setNavBarBottomLineHidden:YES];
    [self custemLeftDefaultBarButtonItem];
    
    
}

#pragma mark - UITableViewDataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 1;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    QGCardNotificationContentCell * cell = (QGCardNotificationContentCell *)[self getCellFromClassName:NSStringFromClass([QGCardNotificationContentCell class]) dequeueTableView:tableView];
    cell.infoModel = self.infoModel;
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return self.infoModel.contentHeight;
}



@end
