//
//  QGCardQuickEntranceCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/30.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGCardQuickEntranceCell.h"
#import "QGBasicUITool.h"
#import "UIImageView+QGWebCache.h"
@interface QGCardQuickEntranceCell () <UICollectionViewDelegate, UICollectionViewDataSource>

/// 承载容器
@property (nonatomic, strong) UICollectionView * collectionView;

@end

@implementation QGCardQuickEntranceCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellEditingStyleNone;
        
        //承载视图
        UICollectionViewFlowLayout * layout = [[UICollectionViewFlowLayout alloc] init];
        layout.scrollDirection = UICollectionViewScrollDirectionVertical;
        layout.itemSize = CGSizeMake(MAINSCREEN_WIDTH/4, 100);
        layout.minimumInteritemSpacing = 0;
        layout.minimumLineSpacing = 0;
        
        self.collectionView = [[UICollectionView alloc] initWithFrame:CGRectZero collectionViewLayout:layout];
        self.collectionView.delegate = self;
        self.collectionView.dataSource = self;
        self.collectionView.backgroundColor = [UIColor whiteColor];
        self.collectionView.scrollEnabled = NO;
        [self.contentView addSubview:self.collectionView];
        
        [self.collectionView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(0);
            make.top.inset(0);
            make.bottom.inset(0);
        }];
        
        //注册cell
        [self.collectionView registerClass:[QGCardQuickEntranceCollectionCell class] forCellWithReuseIdentifier:NSStringFromClass([QGCardQuickEntranceCollectionCell class])];
    }
    return self;
}

#pragma mark - UICollectionViewDataSource
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return MIN(self.cashbackList.count, 4);
}

- (__kindof UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    QGCardQuickEntranceCollectionCell * cell = (QGCardQuickEntranceCollectionCell *)[collectionView dequeueReusableCellWithReuseIdentifier:NSStringFromClass([QGCardQuickEntranceCollectionCell class]) forIndexPath:indexPath];
    QGQuickEntranceModel * model = self.cashbackList[indexPath.row];
    cell.nameLabel.text = model.name;
    [cell.iconImgView setMallImageByNomalPlaceholderWithURLString:model.imgUrl];
    return cell;
}

#pragma mark - UICollectionViewDelegate
- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    if (self.clickBlock) {
        self.clickBlock(indexPath.row, self.cashbackList[indexPath.row]);
    }
}

- (void)setCashbackList:(NSArray<QGQuickEntranceModel *> *)cashbackList
{
    if (_cashbackList != cashbackList) {
        _cashbackList = cashbackList;
        [self.collectionView reloadData];
    }
}

@end




@implementation QGCardQuickEntranceCollectionCell

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        
        //icon
        self.iconImgView = [UIImageView creatImageViewWithSuperView:self.contentView imageName:nil];
        [self.iconImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(48, 48));
            make.top.inset(13);
            make.centerX.offset(0);
        }];
        
        //名字
        self.nameLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_regularFontOfSize:12] textColor:[UIColor textColor3333] alignment:NSTextAlignmentCenter];
        [self.nameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.mas_equalTo(self.iconImgView.mas_bottom).offset(3);
            make.height.mas_equalTo(17);
            make.centerX.offset(0);
        }];
    }
    return self;
}

@end
