//
//  QGCardSavingsAccountView.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/31.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGCardSavingsAccountView.h"
#import "QGBasicUITool.h"
#import "UIImageView+QGWebCache.h"

@interface QGCardSavingsAccountView ()

/// 明细按钮
@property (nonatomic, strong, readwrite) UIButton * detailButton;

/// 转入
@property (nonatomic, strong, readwrite) QGGradientShadowButton * intoButton;

/// 转出
@property (nonatomic, strong, readwrite) UIButton * outButton;

/// 账户余额
@property (nonatomic, strong) UILabel * amountLabel;

///充值记录
@property (nonatomic, strong) UIControl * recordView;

/// 第一条时间记录
@property (nonatomic, strong) UILabel * firstTimeLabel;

/// 第一条交易明细
@property (nonatomic, strong) UILabel * firstContentLabel;

/// 第二条时间记录
@property (nonatomic, strong) UILabel * secondTimeLabel;

/// 第二条交易明细
@property (nonatomic, strong) UILabel * secondContentLabel;

/// 充值礼物
@property (nonatomic, strong) UIControl * rechargeGiftView;

/// 充值礼物图标
@property (nonatomic, strong) UIImageView * giftImgView;

/// 充值礼物标题
@property (nonatomic, strong) UILabel * giftTitleLabel;

/// 充值礼物副标题
@property (nonatomic, strong) UILabel * giftSubTitleLabel;
@end


@implementation QGCardSavingsAccountView

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        
        //阴影视图
        UIView * shadowView = [UIView creatViewWithSuperView:self backgroundColor:[UIColor whiteColor]];
        [shadowView setShadowColor:[UIColor shadowColor] shadowRadius:3 shadowOffset:CGSizeMake(0, 1) cornerRadius:6];
        [shadowView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.bottom.top.inset(5);
        }];
        
        //标题
        UILabel * amountTitleLabel = [UILabel creatLabelWithSuperView:shadowView title:@"账户余额(元)" titleFontSize:[UIFont qg_lightFontOfSize:13] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [amountTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.inset(14);
            make.left.inset(15);
            make.height.mas_equalTo(18);
        }];
        
        //明细按钮
        self.detailButton = [UIButton creatButtonWithSuperView:shadowView title:@"账户明细>>" titleFont:[UIFont qg_lightFontOfSize:12] textColor:[UIColor textColor6666]];
        [self.detailButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(15);
            make.centerY.equalTo(amountTitleLabel);
            make.height.mas_equalTo(27);
        }];
        
        //账户余额
        self.amountLabel = [UILabel creatLabelWithSuperView:shadowView title:nil titleFontSize:[UIFont qg_numberFontOfSize:25] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [self.amountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(amountTitleLabel);
            make.top.mas_equalTo(amountTitleLabel.mas_bottom).offset(5);
            make.height.mas_equalTo(29);
        }];
        
        //转入
        self.intoButton = [QGGradientShadowButton creatGradientColorButtonWithSuperView:shadowView title:@"转入" textFont:[UIFont qg_regularFontOfSize:14]];
        [self.intoButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(15);
            make.size.mas_equalTo(CGSizeMake(88, 30));
            make.top.inset(84);
        }];
        
        //转出
        self.outButton = [UIButton creatButtonWithSuperView:shadowView title:@"转出" titleFont:[UIFont qg_regularFontOfSize:14] textColor:[UIColor yyMainThemeColor]];
        [self.outButton setBorder:[UIColor yyMainThemeColor] width:1];
        self.outButton.layer.cornerRadius = 15;
        self.outButton.clipsToBounds = YES;
        [self.outButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.centerY.mas_equalTo(self.intoButton);
            make.right.mas_equalTo(self.intoButton.mas_left).offset(-10);
        }];
        
        //分割线
        UIView * lineView = [UIView creatViewWithSuperView:shadowView backgroundColor:[UIColor lineSeparatorColorDCDC]];
        [lineView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(15);
            make.height.mas_equalTo(0.5);
            make.top.mas_equalTo(self.outButton.mas_bottom).offset(15.5);
        }];
        
        
        //充值记录
        self.recordView = [[UIControl alloc] init];
        [shadowView addSubview:self.recordView];
        [self.recordView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.bottom.inset(0);
            make.top.mas_equalTo(lineView.mas_bottom);
        }];
        [self creatRecordSubViews];
        
        //充值礼物
        self.rechargeGiftView = [[UIControl alloc] init];
        [shadowView addSubview:self.rechargeGiftView];
        [self.rechargeGiftView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.bottom.inset(0);
            make.top.mas_equalTo(lineView.mas_bottom);
        }];
        [self creatRechargeGiftSubViews];
    
        //充值记录点击事件
        [self.recordView addTarget:self action:@selector(recordDetilClick) forControlEvents:UIControlEventTouchUpInside];
        [self.detailButton addTarget:self action:@selector(recordDetilClick) forControlEvents:UIControlEventTouchUpInside];
        //首充礼物点击事件
        [self.rechargeGiftView addTarget:self action:@selector(giftClick) forControlEvents:UIControlEventTouchUpInside];
    }
    return self;
}


/// 创建首冲礼物
- (void)creatRechargeGiftSubViews
{
    //首充礼图标
    self.giftImgView = [UIImageView creatImageViewWithSuperView:self.rechargeGiftView imageName:nil];
    [self.giftImgView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.inset(15);
        make.size.mas_equalTo(CGSizeMake(55, 55));
        make.centerY.offset(0);
    }];
    
    //标题
    self.giftTitleLabel = [UILabel creatLabelWithSuperView:self.rechargeGiftView title:nil titleFontSize:[UIFont qg_mediumFontOfSize:16] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
    [self.giftTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(self.giftImgView.mas_right).offset(6);
        make.right.inset(10);
        make.top.inset(18.5);
        make.height.mas_equalTo(22);
    }];
    
    //副标题
    self.giftSubTitleLabel = [UILabel creatLabelWithSuperView:self.rechargeGiftView title:nil titleFontSize:[UIFont qg_regularFontOfSize:12] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
    [self.giftSubTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.mas_equalTo(self.giftTitleLabel);
        make.top.mas_equalTo(self.giftTitleLabel.mas_bottom).offset(3);
        make.height.mas_equalTo(17);
    }];
}


/// 创建充值记录
- (void)creatRecordSubViews
{
    //点位
    UIView * firstPoint = [UIView creatViewWithSuperView:self.recordView backgroundColor:[UIColor colorWithHexString:@"D7D7D7"]];
    firstPoint.tag = 10;
    firstPoint.layer.cornerRadius = 3;
    firstPoint.clipsToBounds = YES;
    [firstPoint mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(6, 6));
        make.left.inset(12);
        make.top.inset(26.5);
    }];
    
    //第一条记录的时间
    self.firstTimeLabel = [UILabel creatLabelWithSuperView:self.recordView title:nil titleFontSize:[UIFont qg_regularFontOfSize:12] textColor:[UIColor textColor9999] alignment:NSTextAlignmentRight];
    self.firstTimeLabel.tag = 30;
    [self.firstTimeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.inset(15);
        make.centerY.mas_equalTo(firstPoint);
        make.width.mas_equalTo(70);
    }];
    
    
    //第一条交易的内容
    self.firstContentLabel = [UILabel creatLabelWithSuperView:self.recordView title:nil titleFontSize:[UIFont qg_regularFontOfSize:12] textColor:[UIColor textColor6666] alignment:NSTextAlignmentLeft];
    self.firstContentLabel.tag = 20;
    [self.firstContentLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(firstPoint.mas_right).offset(6);
        make.right.mas_equalTo(self.firstTimeLabel.mas_left).offset(-5);
        make.centerY.mas_equalTo(firstPoint);
    }];
    
    //第二个点
    UIView * secendPointView = [UIView creatViewWithSuperView:self.recordView backgroundColor:[UIColor colorWithHexString:@"D7D7D7"]];
    secendPointView.tag = 11;
    secendPointView.layer.cornerRadius = 3;
    secendPointView.clipsToBounds = YES;
    [secendPointView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.width.height.mas_equalTo(firstPoint);
        make.top.mas_equalTo(firstPoint.mas_bottom).offset(21);
    }];
    
    //第二条时间
    self.secondTimeLabel = [UILabel creatLabelWithSuperView:self.recordView title:nil titleFontSize:self.firstTimeLabel.font textColor:self.firstTimeLabel.textColor alignment:self.firstTimeLabel.textAlignment];
    self.secondTimeLabel.tag = 31;
    [self.secondTimeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.width.mas_equalTo(self.firstTimeLabel);
        make.centerY.mas_equalTo(secendPointView);
    }];
    
    //第二条内容
    self.secondContentLabel = [UILabel creatLabelWithSuperView:self.recordView title:nil titleFontSize:self.firstContentLabel.font textColor:self.firstContentLabel.textColor alignment:self.firstContentLabel.textAlignment];
    self.secondContentLabel.tag = 21;
    [self.secondContentLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.mas_equalTo(self.firstContentLabel);
        make.centerY.mas_equalTo(secendPointView);
    }];
    
}


/// 设置储蓄账户展示需要字段
/// @param amount 储蓄账户余额
/// @param adModel 首冲广告
/// @param recordList 交易记录
- (void)setAmount:(NSString *)amount firstDepositAd:(QGFirstDepositAdModel *)adModel depositRecordList:(NSArray <QGDepositRecordVoModel *> *)recordList
{
    self.amountLabel.text = amount;
    //优先判断交易记录 广告和交易记录是互斥的
    if (recordList.count > 0) {
        self.rechargeGiftView.hidden = YES;
        self.recordView.hidden = NO;
        //处理交易记录的展示
        //最多从数组取两个出来
        for (NSInteger i = 0; i < 2; i++) {
            QGDepositRecordVoModel * recordModel;
            if (recordList.count > i) {
                recordModel = recordList[i];
            }
            
            UIView * poineView = [self.recordView viewWithTag:10 + i];
            UILabel * contentLabel = [self.recordView viewWithTag:20 + i];
            UILabel * timeLabel = [self.recordView viewWithTag:30 + i];
            //存在则赋值，不存在则隐藏视图
            if (recordModel) {
                poineView.hidden = NO;
                contentLabel.hidden = NO;
                timeLabel.hidden = NO;
                contentLabel.text = recordModel.content;
                timeLabel.text = recordModel.showTimeStr;
            }
            else
            {
                poineView.hidden = YES;
                contentLabel.hidden = YES;
                timeLabel.hidden = YES;
            }
        }
    }
    else if (adModel)
    {
        self.recordView.hidden = YES;
        self.rechargeGiftView.hidden = NO;
        //处理首冲广告的展示
        [self.giftImgView setMallImageByNomalPlaceholderWithURLString:adModel.imgUrl];
        self.giftTitleLabel.text = adModel.title;
        self.giftSubTitleLabel.text = adModel.subTitle;
    }
}


#pragma mark - action
///交易记录
- (void)recordDetilClick
{
    if (self.detailClickBlock) {
        self.detailClickBlock();
    }
}

///首冲礼
- (void)giftClick
{
    if (self.rechargeGiftClickBlock) {
        self.rechargeGiftClickBlock();
    }
}

@end
