//
//  QGCardSavingsAccountView.h
//  VirtualPayment
//
//  Created by 张博 on 2020/3/31.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "QGGradientShadowButton.h"
#import "QGCardHomeModel.h"
NS_ASSUME_NONNULL_BEGIN

/// 储蓄账户
@interface QGCardSavingsAccountView : UIView


/// 明细点击
@property (nonatomic, copy) dispatch_block_t detailClickBlock;

/// 首次充值礼物点击事件
@property (nonatomic, copy) dispatch_block_t rechargeGiftClickBlock;

/// 转入
@property (nonatomic, strong, readonly) QGGradientShadowButton * intoButton;

/// 转出
@property (nonatomic, strong, readonly) UIButton * outButton;



/// 设置储蓄账户展示需要字段
/// @param amount 储蓄账户余额
/// @param adModel 首冲广告
/// @param recordList 交易记录
- (void)setAmount:(NSString *)amount firstDepositAd:(QGFirstDepositAdModel *)adModel depositRecordList:(NSArray <QGDepositRecordVoModel *> *)recordList;

@end

NS_ASSUME_NONNULL_END
