//
//  QGCardBillSubCell.m
//  VirtualPayment
//
//  Created by 张博 on 2019/11/13.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGCardBillSubView.h"

#import "QGBasicUITool.h"

@interface QGCardBillSubView ()

/// 标题
@property (nonatomic, strong, readwrite) UILabel * titleLabel;

/// 状态
@property (nonatomic, strong, readwrite) UILabel * descLabel;

/// 去看看 | 去修改
@property (nonatomic, strong, readwrite) UILabel * showLabel;

/// 右侧icon图片
@property (nonatomic, strong, readwrite) UIImageView * rightIconImageView;

/// 点击事件按钮
@property (nonatomic, strong, readwrite) UIButton * subCellClickButton;

@end

@implementation QGCardBillSubView

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        
        //设置阴影和圆角
//       [self setShadowColor:[UIColor shadowColor] shadowRadius:3 shadowOffset:CGSizeMake(0, 2) cornerRadius:5];
        
        //标题
        self.titleLabel = [UILabel creatLabelWithSuperView:self title:nil titleFontSize:[UIFont qg_mediumFontOfSize:12] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.inset(15);
            make.left.inset(15);
            make.height.mas_equalTo(17);
        }];
        
        //图片
        self.rightIconImageView = [UIImageView creatImageViewWithSuperView:self imageName:@"card_bill"];
        [self.rightIconImageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(44, 47));
            make.right.inset(6);
            make.centerY.offset(0);
        }];
        
        
        //状态
        self.descLabel = [UILabel creatLabelWithSuperView:self title:@"" titleFontSize:[UIFont qg_lightFontOfSize:12] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        self.descLabel.adjustsFontSizeToFitWidth = YES;
        [self.descLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.titleLabel.mas_left);
            make.right.mas_equalTo(self.rightIconImageView.mas_left).offset(1);
            make.height.mas_equalTo(17);
            make.top.mas_equalTo(self.titleLabel.mas_bottom);
        }];
        
        //去看看
        self.showLabel = [UILabel creatLabelWithSuperView:self title:nil titleFontSize:[UIFont qg_lightFontOfSize:9] textColor:[UIColor textColor9999] alignment:NSTextAlignmentCenter];
        self.showLabel.layer.cornerRadius = 2;
        self.showLabel.clipsToBounds = YES;
        [self.showLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(47, 15));
            make.left.mas_equalTo(self.titleLabel.mas_left);
            make.top.mas_equalTo(self.descLabel.mas_bottom).offset(5);
        }];
        
        //点击事件按钮
        self.subCellClickButton = [UIButton creatButtonWithSuperView:self title:nil titleFont:nil textColor:nil];
        [self.subCellClickButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.top.bottom.inset(0);
        }];
    }
    return self;
}

@end
