//
//  QGCardAccountSegmentView.h
//  VirtualPayment
//
//  Created by 张博 on 2020/3/31.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSUInteger, QGAccountSegmentViewSelectType) {
    //信用账户
    QGAccountSegmentViewSelectTypeCredit = 1,
    //储蓄账户
    QGAccountSegmentViewSelectTypeSavings
};

///选中block
typedef void(^QAccountSegmentViewSelectBlock)(QGAccountSegmentViewSelectType selectType);


@interface QGCardAccountSegmentView : UIView

/// 选中的block
@property (nonatomic, copy) QAccountSegmentViewSelectBlock selectBlock;

/// 储蓄账户显示的标签
@property (nonatomic, strong) NSString * tagString;

/// 外部选中事件
- (void)resetSelectButton:(QGAccountSegmentViewSelectType)selectType;
@end

NS_ASSUME_NONNULL_END
