//
//  QGCardAccountReviewingCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/4/1.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGCardAccountReviewingCell.h"
#import "QGGradientShadowButton.h"
#import "QGBasicUITool.h"

@interface QGCardAccountReviewingCell ()

/// 标题
@property (nonatomic, strong) UILabel * titleLabel;

/// 描述
@property (nonatomic, strong) UILabel * descLabel;

@end

@implementation QGCardAccountReviewingCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        //全部禁用并设置成灰色
        self.creditView.billSubCell.titleLabel.textColor = [UIColor textColor9999];
        self.creditView.billSubCell.showLabel.backgroundColor = [UIColor lineSeparatorColorDCDC];
        self.creditView.billSubCell.showLabel.textColor = [UIColor whiteColor];
        self.creditView.billSubCell.rightIconImageView.alpha = 0.5;
        self.creditView.billSubCell.subCellClickButton.userInteractionEnabled = NO;
        
        self.creditView.configTermSubCell.titleLabel.textColor = [UIColor textColor9999];
        self.creditView.configTermSubCell.showLabel.backgroundColor = [UIColor lineSeparatorColorDCDC];
        self.creditView.configTermSubCell.showLabel.textColor = [UIColor whiteColor];
        self.creditView.configTermSubCell.rightIconImageView.alpha = 0.5;
        self.creditView.configTermSubCell.subCellClickButton.userInteractionEnabled = NO;
        
        //标题
        self.titleLabel = [UILabel creatLabelWithSuperView:self.creditView.shadowContentView title:nil titleFontSize:[UIFont qg_mediumFontOfSize:18] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.top.inset(15);
            make.height.mas_equalTo(25);
        }];
        
        //描述
        self.descLabel = [UILabel creatLabelWithSuperView:self.creditView.shadowContentView title:nil titleFontSize:[UIFont qg_lightFontOfSize:13] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        self.descLabel.numberOfLines = 0;
        [self.descLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.titleLabel);
            make.height.mas_equalTo(18);
            make.top.mas_equalTo(self.titleLabel.mas_bottom).offset(5);
        }];
        
        //激活按钮
        QGGradientShadowButton * activeButton = [QGGradientShadowButton creatGradientColorButtonWithSuperView:self.creditView.shadowContentView title:@"激活额度" textFont:[UIFont qg_regularFontOfSize:14]];
        [activeButton setGradientButtonIsClickEnabled:NO];
        [activeButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(15);
            make.size.mas_equalTo(CGSizeMake(107, 30));
            make.top.inset(84);
        }];
        
        
        
    }
    return self;
}

- (void)setDataModel:(QGCardHomeModel *)dataModel
{
    [super setDataModel:dataModel];
    
    //0-初始状态，1-激活成功，2-激活失败，4-审核中
    switch (dataModel.blankNote.creditAccountStatusEnumType.integerValue) {
            //审核中
        case 4:
        {
            self.titleLabel.text = @"审核中...";
            self.descLabel.text = @"实际额度，以最终审核为主";
        }
            break;
            //审核失败
        case 2:
        {
            self.titleLabel.text = @": ( 审核失败";
            self.descLabel.text = @"请尝试使用一段时间真享生活的其它产品，积累信用，再申请！";
        }
            break;
            
        default:
            break;
    }

    
}


@end
