//
//  QGCardAccountReviewSuccessCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/4/1.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGCardAccountReviewSuccessCell.h"
#import "QGBasicUITool.h"

@interface QGCardAccountReviewSuccessCell ()

/// 授信额度展示
@property (nonatomic, strong) UILabel * canUseAmountLabel;

/// 已冻结展示
@property (nonatomic, strong) UILabel * lockLabel;

/// 额度管理按钮
@property (nonatomic, strong, readwrite) UIButton * quotaButton;

/// 还款标题
@property (nonatomic, strong) UILabel * repayTitleLabel;

/// 还款金额
@property (nonatomic, strong) UILabel * repayAmountLabel;

/// 还款按钮
@property (nonatomic, strong, readwrite) QGGradientShadowButton * repaymentButton;

@end

@implementation QGCardAccountReviewSuccessCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        //标题
        UILabel * amountLabel = [UILabel creatLabelWithSuperView:self.creditView.shadowContentView title:@"可用额度(元)" titleFontSize:[UIFont qg_lightFontOfSize:13] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [amountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.top.inset(15);
            make.height.mas_equalTo(18);
        }];
        
        //额度管理
        self.quotaButton = [UIButton creatButtonWithSuperView:self.creditView.shadowContentView title:@"额度管理>>" titleFont:[UIFont qg_lightFontOfSize:12] textColor:[UIColor textColor6666]];
        [self.quotaButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.height.mas_equalTo(17);
            make.top.right.inset(15);
        }];
        [self.quotaButton setImage:[UIImage imageNamed:@"card_credit_quota_flag"] forState:UIControlStateNormal];
        

        
        
        //金额
        self.canUseAmountLabel = [UILabel creatLabelWithSuperView:self.creditView.shadowContentView title:nil titleFontSize:[UIFont qg_numberFontOfSize:25] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [self.canUseAmountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(amountLabel);
            make.top.mas_equalTo(amountLabel.mas_bottom).offset(5);
            make.height.mas_equalTo(29);
        }];
        
        //已冻结
        self.lockLabel = [UILabel creatLabelWithSuperView:self.creditView.shadowContentView title:@"(已冻结)" titleFontSize:[UIFont qg_lightFontOfSize:13] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        [self.lockLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.canUseAmountLabel.mas_right).offset(4);
            make.height.mas_equalTo(18);
            make.bottom.mas_equalTo(self.canUseAmountLabel).offset(-3);
        }];
        
        
        //还款标题
        self.repayTitleLabel = [UILabel creatLabelWithSuperView:self.creditView.shadowContentView title:nil titleFontSize:[UIFont qg_lightFontOfSize:13] textColor:nil alignment:NSTextAlignmentLeft];
        [self.repayTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(amountLabel);
            make.top.mas_equalTo(self.canUseAmountLabel.mas_bottom).offset(22);
            make.height.mas_equalTo(18);
        }];
    
        //金额
        self.repayAmountLabel = [UILabel creatLabelWithSuperView:self.creditView.shadowContentView title:nil titleFontSize:[UIFont qg_numberFontOfSize:18] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [self.repayAmountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.repayTitleLabel.mas_right).offset(0);
            make.centerY.mas_equalTo(self.repayTitleLabel);
            make.height.mas_equalTo(21);
        }];
        
        //还款按钮
        self.repaymentButton = [QGGradientShadowButton creatGradientColorButtonWithSuperView:self.creditView.shadowContentView title:@"" textFont:[UIFont qg_lightFontOfSize:12]];
        [self.repaymentButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(88, 24));
            make.right.inset(15);
            make.centerY.mas_equalTo(self.repayTitleLabel);
        }];
        
        
    }
    return self;
}


- (void)setDataModel:(QGCardHomeModel *)dataModel
{
    [super setDataModel:dataModel];
    self.canUseAmountLabel.text = [NSString stringWithFormat:@"%.2f",dataModel.blankNote.canUseAmount.floatValue];
    
    /**
    * 还款账单状态
    * 1: 未消费
    * 2：已消费，未出账
    * 3：已出账，待还款（1-10号展示）
    * 4：还款日后，逾期
    * 5：还款成功
    */
    NSInteger billStatus = dataModel.blankNote.repayBillStatusEnumType.integerValue;
    self.lockLabel.hidden = YES;
    self.canUseAmountLabel.textColor = [UIColor textColor3333];
    self.creditView.billSubCell.descLabel.textColor = [UIColor textColor9999];
    self.repayTitleLabel.text = dataModel.blankNote.repayContent;
    self.repayTitleLabel.textColor = [UIColor textColor3333];
    [self.repaymentButton setTitle:@"立即还款" forState:UIControlStateNormal];
    //1: 未消费
    if (billStatus == 1) {
        self.repayAmountLabel.text = [NSString stringWithFormat:@"%.2f",dataModel.blankNote.usedAmount.floatValue];
        [self.repaymentButton setTitle:@"提前还款" forState:UIControlStateNormal];
        [self.repaymentButton setGradientButtonIsClickEnabled:NO];
        
    }
    //2：已消费，未出账 || 5：还款成功
    else if (billStatus == 2 || billStatus == 5)
    {
        self.repayAmountLabel.text = [NSString stringWithFormat:@"%.2f",dataModel.blankNote.nextRepayAmount.floatValue];
        [self.repaymentButton setTitle:@"提前还款" forState:UIControlStateNormal];
        //有金额
        if (dataModel.blankNote.nextRepayAmount.floatValue > 0) {
            [self.repaymentButton setGradientButtonIsClickEnabled:YES];
        }
        else
        {
            [self.repaymentButton setGradientButtonIsClickEnabled:NO];
        }
    }
    //3：已出账，待还款（1-10号展示）
    else if (billStatus == 3)
    {
        self.repayAmountLabel.text = [NSString stringWithFormat:@"%.2f",dataModel.blankNote.repayAmount.floatValue];
         [self.repaymentButton setGradientButtonIsClickEnabled:YES];
    }
    //4：还款日后，逾期
    else if (billStatus == 4) {
        self.lockLabel.hidden = NO;
        self.canUseAmountLabel.textColor = [UIColor textColor9999];
        self.creditView.billSubCell.descLabel.textColor = [UIColor textColorF41C1C];
        self.repayTitleLabel.textColor = [UIColor textColorF41C1C];
        self.repayAmountLabel.text = [NSString stringWithFormat:@"%.2f",dataModel.blankNote.overdueAmount.floatValue];
        [self.repaymentButton setGradientButtonIsClickEnabled:YES];
    }
    
    //有提额标识
    if (dataModel.blankNote.isHasQuotaFlag.boolValue) {
        [self.quotaButton setImage:[UIImage imageNamed:@"card_credit_quota_flag"] forState:UIControlStateNormal];
    }
    else
    {
        [self.quotaButton setImage:nil forState:UIControlStateNormal];
    }
    
}

@end
