//
//  QGCardAccountNormalCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/4/1.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGCardAccountNormalCell.h"
#import "QGBasicUITool.h"

@interface QGCardAccountNormalCell ()

/// 授信额度展示
@property (nonatomic, strong) UILabel * amountLabel;

/// 激活按钮
@property (nonatomic, strong, readwrite) QGGradientShadowButton * activeButton;

@end

@implementation QGCardAccountNormalCell


- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        
        //全部禁用并设置成灰色
        self.creditView.billSubCell.titleLabel.textColor = [UIColor textColor9999];
        self.creditView.billSubCell.showLabel.backgroundColor = [UIColor lineSeparatorColorDCDC];
        self.creditView.billSubCell.showLabel.textColor = [UIColor whiteColor];
        self.creditView.billSubCell.rightIconImageView.alpha = 0.5;
        self.creditView.billSubCell.subCellClickButton.userInteractionEnabled = NO;
        
        self.creditView.configTermSubCell.titleLabel.textColor = [UIColor textColor9999];
        self.creditView.configTermSubCell.showLabel.backgroundColor = [UIColor lineSeparatorColorDCDC];
        self.creditView.configTermSubCell.showLabel.textColor = [UIColor whiteColor];
        self.creditView.configTermSubCell.rightIconImageView.alpha = 0.5;
        self.creditView.configTermSubCell.subCellClickButton.userInteractionEnabled = NO;
        
        //标题
        UILabel * amountLabel = [UILabel creatLabelWithSuperView:self.creditView.shadowContentView title:@"最高额度(元)" titleFontSize:[UIFont qg_lightFontOfSize:13] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [amountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.top.inset(15);
            make.height.mas_equalTo(18);
        }];
        
        //金额
        self.amountLabel = [UILabel creatLabelWithSuperView:self.creditView.shadowContentView title:@"50,000.00" titleFontSize:[UIFont qg_numberFontOfSize:25] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [self.amountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(amountLabel);
            make.top.mas_equalTo(amountLabel.mas_bottom).offset(4);
            make.height.mas_equalTo(29);
        }];
        
        //提示
        UILabel * hintLabel = [UILabel creatLabelWithSuperView:self.creditView.shadowContentView title:@"实际额度，以最终审批为主" titleFontSize:[UIFont qg_lightFontOfSize:10] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        [hintLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(amountLabel);
            make.height.mas_equalTo(14);
            make.top.mas_equalTo(self.amountLabel.mas_bottom).offset(2);
        }];
        
        //激活按钮
        self.activeButton = [QGGradientShadowButton creatGradientColorButtonWithSuperView:self.creditView.shadowContentView title:@"激活额度" textFont:[UIFont qg_regularFontOfSize:14]];
        [self.activeButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(15);
            make.size.mas_equalTo(CGSizeMake(107, 30));
            make.top.inset(84);
        }];
        
        
        
    }
    return self;
}

//- (void)setDataModel:(QGCardHomeModel *)dataModel
//{
//    [super setDataModel:dataModel];
//    self.amountLabel.text = dataModel.blankNote.creditMaxAmount;
//}


@end
