//
//  QGCardHeaderReviewSuccessCell.m
//  VirtualPayment
//
//  Created by 张博 on 2019/11/12.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGCardHeaderReviewSuccessCell.h"

#import "QGCardReviewSuccessAnimationView.h"
#import "QGPasteboardLabel.h"
#import "ZHAttributedLabelTool.h"
@interface QGCardHeaderReviewSuccessCell ()

/// 光动画
@property (nonatomic, strong) QGCardReviewSuccessAnimationView * lightAnimationView;

/// 卡号
@property (nonatomic, strong) QGPasteboardLabel * bankCardNumLabel;

/// 用户名称
@property (nonatomic, strong) UILabel * nameLabel;

/// 绑定卡号
@property (nonatomic, strong, readwrite) UIButton * bindingCardButton;
@end

@implementation QGCardHeaderReviewSuccessCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        //光动画
        self.lightAnimationView = [[QGCardReviewSuccessAnimationView alloc] init];
        [self.cardContentView addSubview:self.lightAnimationView];
        [self.lightAnimationView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.top.inset(0);
            make.size.mas_equalTo(CGSizeMake(convertEqualScaleFrom375(215), convertEqualScaleFrom375(200)));
        }];
        
        
        //号码标题
        UILabel * numTitle = [UILabel creatLabelWithSuperView:self.cardContentView title:@"NO." titleFontSize:[UIFont qg_lightFontOfSize:convertEqualScaleFrom375(9)] textColor:[UIColor whiteColor] alignment:NSTextAlignmentLeft];
        [numTitle mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(convertEqualScaleFrom375(15));
            make.height.mas_equalTo(convertEqualScaleFrom375(13));
            make.top.inset(convertEqualScaleFrom375(65));
        }];
        
        //号码
        self.bankCardNumLabel = [[QGPasteboardLabel alloc] init];
        self.bankCardNumLabel.font = [UIFont qg_numberFontOfSize:convertEqualScaleFrom375(22)];
        self.bankCardNumLabel.textColor = [UIColor whiteColor];
        [self.cardContentView addSubview:self.bankCardNumLabel];
        self.bankCardNumLabel.isClearWhitespace = YES;
        [self.bankCardNumLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(convertEqualScaleFrom375(15));
            make.height.mas_equalTo(convertEqualScaleFrom375(26));
            make.top.mas_equalTo(numTitle.mas_bottom).offset(convertEqualScaleFrom375(4));
        }];
        
        //名字标题
        UILabel * nameTitleLabel = [UILabel creatLabelWithSuperView:self.cardContentView title:@"NAME" titleFontSize:[UIFont qg_lightFontOfSize:9] textColor:[UIColor whiteColor] alignment:NSTextAlignmentLeft];
        [nameTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(convertEqualScaleFrom375(15));
            make.top.mas_equalTo(self.bankCardNumLabel.mas_bottom).offset(convertEqualScaleFrom375(25));
            make.height.mas_equalTo(convertEqualScaleFrom375(13));
        }];
        
        //名字
        self.nameLabel = [UILabel creatLabelWithSuperView:self.cardContentView title:nil titleFontSize:[UIFont qg_regularFontOfSize:convertEqualScaleFrom375(14)] textColor:[UIColor whiteColor] alignment:NSTextAlignmentLeft];
        [self.nameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(convertEqualScaleFrom375(15));
            make.top.mas_equalTo(nameTitleLabel.mas_bottom).offset(convertEqualScaleFrom375(2));
            make.height.mas_equalTo(convertEqualScaleFrom375(20));
        }];
        
        //绑卡按钮
        self.bindingCardButton = [UIButton creatButtonWithSuperView:self.cardContentView title:@"立即绑卡>>" titleFont:[UIFont qg_regularFontOfSize:convertEqualScaleFrom375(12)] textColor:[UIColor whiteColor]];
        [self.bindingCardButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(convertEqualScaleFrom375(15));
            make.bottom.inset(convertEqualScaleFrom375(convertEqualScaleFrom375(27)));
        }];
    }
    return self;
}

- (void)setBlanNoteModel:(QGBlankNoteModel *)blanNoteModel
{
    [super setBlanNoteModel:blanNoteModel];
    
    
    ZHAttributedLabelTool * cardTool = [[ZHAttributedLabelTool alloc] initWithText:[self.blanNoteModel.sySecondAccountCardNo formatterBankCardNum] font:self.bankCardNumLabel.font color:self.bankCardNumLabel.textColor];
    [cardTool addKerningWithSpace:2];
    self.bankCardNumLabel.attributedText = [cardTool getResultString];
    self.nameLabel.text = self.blanNoteModel.sySecondAccountCardHolder;
    
    [self.lightAnimationView startAnimation];
    
    BOOL isHiddenBinding = YES;
    //二类户激活成功就可以显示绑卡
    if (blanNoteModel.depositAccountStatusEnumType.integerValue == 1) {
        isHiddenBinding = !blanNoteModel.showCreditDesc.boolValue;
    }
    //绑定教程不展示，按钮也隐藏掉
    self.bindingCardButton.hidden = isHiddenBinding;
}


- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
