//
//  QGCardNormalStatusAnimationView.m
//  VirtualPayment
//
//  Created by 张博 on 2019/11/8.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGCardNormalStatusAnimationView.h"

#import "QGBasicUITool.h"

@interface QGCardNormalStatusAnimationView ()

/// 数字8的图片
@property (nonatomic, strong) UIImageView * eightImageView;

/// 数字8的动画组
@property (nonatomic, strong) CAAnimationGroup * eightAnimationGroup;

/// 左侧光
@property (nonatomic, strong) UIImageView * leftLightImageView;

/// 左侧光动画组
@property (nonatomic, strong) CAAnimationGroup * leftLightAnimationGroup;

/// 右侧光
@property (nonatomic, strong) UIImageView * rightLightImageView;

/// 左侧光动画组
@property (nonatomic, strong) CAAnimationGroup * rightLightAnimationGroup;
@end


@implementation QGCardNormalStatusAnimationView

- (CGSize)intrinsicContentSize
{
    return CGSizeMake(convertEqualScaleFrom375(150), convertEqualScaleFrom375(116));
}


- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        
        
        //左侧光
        self.leftLightImageView = [UIImageView creatImageViewWithSuperView:self imageName:@"card_header_light"];
        self.leftLightImageView.frame = CGRectMake(0, 0, convertEqualScaleFrom375(162), convertEqualScaleFrom375(107));
        self.leftLightImageView.centerX = self.width / 2.0;
        self.leftLightImageView.centerY = self.height;
        self.leftLightImageView.layer.anchorPoint = CGPointMake(0.5, 1);
        self.leftLightImageView.layer.zPosition = 2;
        //右侧光
        self.rightLightImageView = [UIImageView creatImageViewWithSuperView:self imageName:@"card_header_light"];
        self.rightLightImageView.frame = CGRectMake(0, 0, convertEqualScaleFrom375(162), convertEqualScaleFrom375(107));
        self.rightLightImageView.centerX = self.width / 2.0;
        self.rightLightImageView.centerY = self.height;
        self.rightLightImageView.layer.anchorPoint = CGPointMake(0.5, 1);
        self.rightLightImageView.layer.zPosition = 3;
        
        //数字8
        self.eightImageView = [UIImageView creatImageViewWithSuperView:self imageName:@"card_header_eight"];
        self.eightImageView.frame = CGRectMake(0, convertEqualScaleFrom375(41), convertEqualScaleFrom375(47), convertEqualScaleFrom375(58));
        self.eightImageView.centerX = self.width / 2.0;
        self.eightImageView.layer.zPosition = 4;
       
        //总共时间分成8份
        CGFloat animationDuration = 0.3 * 8;
        [self creatEightImageViewAnimationDuration:animationDuration];
        [self creatLeftLightImageViewAnimationDuration:animationDuration];
        [self creatRightLightImageViewAnimationDuration:animationDuration];
        
        
         [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(willResignActive) name:UIApplicationWillResignActiveNotification object:nil];
    }
    return self;
}

///添加8的动画
- (void)creatEightImageViewAnimationDuration:(CGFloat)animationDuration
{
    //位移动画
    CAKeyframeAnimation * positionAnimation = [CAKeyframeAnimation animationWithKeyPath:@"position.y"];
    positionAnimation.values = @[@(convertEqualScaleFrom375(41 + 29)),@(convertEqualScaleFrom375(51 + 29)),@(convertEqualScaleFrom375(21 + 29)),@(convertEqualScaleFrom375(11 + 29)),@(convertEqualScaleFrom375(51 + 29)),@(convertEqualScaleFrom375(21 + 29)),@(convertEqualScaleFrom375(11 + 29)),@(convertEqualScaleFrom375(51 + 29)),@(convertEqualScaleFrom375(41 + 29))];
    positionAnimation.duration = animationDuration;
    positionAnimation.keyTimes = @[@(0),@(0.125),@(0.25),@(0.375),@(0.5),@(0.625),@(0.75),@(0.875),@(1)];
    
    //图层等级
    CAKeyframeAnimation * zPositionAnimation = [CAKeyframeAnimation animationWithKeyPath:@"zPosition"];
    zPositionAnimation.duration = animationDuration;
    zPositionAnimation.values = @[@(4),@(4),@(4),@(4),@(1),@(1),@(1),@(4),@(4)];
    zPositionAnimation.keyTimes = @[@(0),@(0.125),@(0.25),@(0.375),@(0.5),@(0.625),@(0.75),@(0.875),@(1)];
    
    CAAnimationGroup * animationGroup = [CAAnimationGroup animation];
    animationGroup.animations = @[positionAnimation,zPositionAnimation];
    animationGroup.duration = animationDuration;
    self.eightAnimationGroup = animationGroup;
    
}

///添加左侧光动画
- (void)creatLeftLightImageViewAnimationDuration:(CGFloat)animationDuration
{
    //X缩放动画
    CAKeyframeAnimation * scaleAnimation  = [CAKeyframeAnimation animationWithKeyPath:@"transform.scale.x"];
    scaleAnimation.values = @[@(1),@(1),@(0.65),@(0.25),@(1),@(1),@(0.65),@(0.25),@(1)];
    scaleAnimation.keyTimes = @[@(0),@(0.125),@(0.25),@(0.375),@(0.5),@(0.625),@(0.75),@(0.875),@(1)];
    scaleAnimation.duration = animationDuration;

    //设置x轴方向的移动动画
    CAKeyframeAnimation * xTranslationAnimation = [CAKeyframeAnimation animationWithKeyPath:@"transform.translation.x"];
    xTranslationAnimation.values = @[@(0),@(0),@(-convertEqualScaleFrom375(21)),@(-convertEqualScaleFrom375(28)),@(0),@(0),@(-convertEqualScaleFrom375(9)),@(-convertEqualScaleFrom375(28)),@(0)];
    xTranslationAnimation.keyTimes = @[@(0),@(0.125),@(0.25),@(0.375),@(0.5),@(0.625),@(0.75),@(0.875),@(1)];
    xTranslationAnimation.duration = animationDuration;

    //旋转动画
    CAKeyframeAnimation * rotationAnimation = [CAKeyframeAnimation animationWithKeyPath:@"transform.rotation"];
    rotationAnimation.values = @[@(0),@(0),@(-15/180.0*M_PI),@(-30/180.0*M_PI),@(0),@(0),@(-15/180.0*M_PI),@(-30/180.0*M_PI),@(0)];
    rotationAnimation.keyTimes = @[@(0),@(0.125),@(0.25),@(0.375),@(0.5),@(0.625),@(0.75),@(0.875),@(1)];
    rotationAnimation.duration = animationDuration;

    CAAnimationGroup * animationGroup = [CAAnimationGroup animation];
    animationGroup.animations = @[scaleAnimation,xTranslationAnimation,rotationAnimation];
    animationGroup.duration = animationDuration;
    self.leftLightAnimationGroup = animationGroup;
}

///添加右侧光动画
- (void)creatRightLightImageViewAnimationDuration:(CGFloat)animationDuration
{
    //缩放动画
    CAKeyframeAnimation * scaleAnimation  = [CAKeyframeAnimation animationWithKeyPath:@"transform.scale.x"];
    scaleAnimation.values = @[@(1),@(1),@(0.65),@(0.25),@(1),@(1),@(0.65),@(0.25),@(1)];
    scaleAnimation.keyTimes = @[@(0),@(0.125),@(0.25),@(0.375),@(0.5),@(0.625),@(0.75),@(0.875),@(1)];
    scaleAnimation.duration = animationDuration;
    
    //设置x轴方向的移动动画
    CAKeyframeAnimation * xTranslationAnimation = [CAKeyframeAnimation animationWithKeyPath:@"transform.translation.x"];
    xTranslationAnimation.values = @[@(0),@(0),@(convertEqualScaleFrom375(12)),@(convertEqualScaleFrom375(25)),@(0),@(0),@(convertEqualScaleFrom375(5)),@(convertEqualScaleFrom375(25)),@(0)];
    xTranslationAnimation.keyTimes = @[@(0),@(0.125),@(0.25),@(0.375),@(0.5),@(0.625),@(0.75),@(0.875),@(1)];
    xTranslationAnimation.duration = animationDuration;
    
    //旋转动画
    CAKeyframeAnimation * rotationAnimation = [CAKeyframeAnimation animationWithKeyPath:@"transform.rotation"];
    rotationAnimation.values = @[@(0),@(0),@(15/180.0*M_PI),@(30/180.0*M_PI),@(0),@(0),@(15/180.0*M_PI),@(30/180.0*M_PI),@(0)];
    rotationAnimation.keyTimes = @[@(0),@(0.125),@(0.25),@(0.375),@(0.5),@(0.625),@(0.75),@(0.875),@(1)];
    rotationAnimation.duration = animationDuration;
    
    CAAnimationGroup * animationGroup = [CAAnimationGroup animation];
    animationGroup.animations = @[scaleAnimation,xTranslationAnimation,rotationAnimation];
    animationGroup.duration = animationDuration;
    self.rightLightAnimationGroup = animationGroup;
}

- (void)startAnimation
{
    [self removeAnimation];
    //添加新动画
    [self.eightImageView.layer addAnimation:self.eightAnimationGroup forKey:nil];
    [self.leftLightImageView.layer addAnimation:self.leftLightAnimationGroup forKey:nil];
    [self.rightLightImageView.layer addAnimation:self.rightLightAnimationGroup forKey:nil];
}

- (void)removeAnimation
{
    //移除动画
    [self.eightImageView.layer removeAllAnimations];
    [self.leftLightImageView.layer removeAllAnimations];
    [self.rightLightImageView.layer removeAllAnimations];
}

///进入后台移除动画
- (void)willResignActive
{
    [self removeAnimation];
}

@end
