//
//  QGCardBindingBottomView.m
//  VirtualPayment
//
//  Created by 张博 on 2020/5/22.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGCardBindingBottomView.h"
#import "QGBasicUITool.h"
@implementation QGCardBindingBottomView

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        
        self.backgroundColor = [UIColor clearColor];
        
        //承载内容容器
        UIView * contentView = [UIView creatViewWithSuperView:self backgroundColor:[[UIColor blackColor] colorWithAlphaComponent:0.4]];
        contentView.layer.cornerRadius = 6;
        contentView.clipsToBounds = YES;
        [contentView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.top.bottom.inset(0);
        }];
        
        //文案
        UILabel * titleLabel = [UILabel creatLabelWithSuperView:contentView title:@"绑定微信、支付宝去支付" titleFontSize:[UIFont qg_regularFontOfSize:12] textColor:[UIColor whiteColor] alignment:NSTextAlignmentLeft];
        [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(15);
            make.centerY.offset(0);
        }];
        
        //支付宝支付
        UIButton * alipyButton = [UIButton creatButtonWithSuperView:contentView title:@"支付宝" titleFont:[UIFont qg_regularFontOfSize:12] textColor:[UIColor whiteColor]];
        alipyButton.tag = BindingCardClickTypeAlipay;
        [alipyButton setBackgroundColor:[UIColor colorWithHexString:@"42B0F4"]];
        alipyButton.layer.cornerRadius = 3;
        alipyButton.clipsToBounds = YES;
        [alipyButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(74, 24));
            make.right.inset(7);
            make.centerY.offset(0);
        }];
        [alipyButton addTarget:self action:@selector(bindingButtonClick:) forControlEvents:UIControlEventTouchUpInside];
        
        
        
        //微信支付
        UIButton * wechatPayButton = [UIButton creatButtonWithSuperView:contentView title:@"微信支付" titleFont:[UIFont qg_regularFontOfSize:12] textColor:[UIColor whiteColor]];
        wechatPayButton.tag = BindingCardClickTypeWechat;
        [wechatPayButton setBackgroundColor:[UIColor colorWithHexString:@"56CD2F"]];
        wechatPayButton.layer.cornerRadius = 3;
        wechatPayButton.clipsToBounds = YES;
        [wechatPayButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(74, 24));
            make.right.mas_equalTo(alipyButton.mas_left).offset(-5);
            make.centerY.offset(0);
        }];
        [wechatPayButton addTarget:self action:@selector(bindingButtonClick:) forControlEvents:UIControlEventTouchUpInside];
        
        
        
        
    }
    return self;
}


- (void)bindingButtonClick:(UIButton *)button
{
    if (self.clickBlock) {
        self.clickBlock(button.tag);
    }
}


@end
