//
//  QGBindingCardSubCell.m
//  VirtualPayment
//
//  Created by 张博 on 2019/11/18.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGBindingCardSubCell.h"

#import "QGBasicUITool.h"
@implementation QGBindingCardSubCell

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        
        
        UIView * shadowView = [UIView creatViewWithSuperView:self backgroundColor:[UIColor whiteColor]];
        [shadowView setShadowColor:[UIColor shadowColor] shadowRadius:3 shadowOffset:CGSizeMake(0, 1) cornerRadius:6];
        shadowView.layer.masksToBounds = NO;
        [shadowView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.top.bottom.inset(2);
        }];
        
        
        
        
        //icon
        self.iconImageView = [UIImageView creatImageViewWithSuperView:shadowView imageName:@""];
        [self.iconImageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.inset(10);
            make.centerX.offset(0);
            make.size.mas_equalTo(CGSizeMake(36, 36));
        }];
        
        
        //标题
        self.titleLabel = [UILabel creatLabelWithSuperView:shadowView title:nil titleFontSize:[UIFont qg_mediumFontOfSize:16] textColor:[UIColor whiteColor] alignment:NSTextAlignmentCenter];
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.width.mas_equalTo(70);
            make.centerX.offset(0);
            make.height.mas_equalTo(24);
            make.top.mas_equalTo(self.iconImageView.mas_bottom).offset(6);
        }];
        self.titleLabel.layer.cornerRadius = 3;
        self.titleLabel.clipsToBounds = YES;

    }
    return self;
}


@end
