//
//  QGConfigInstallmentPlanModel.h
//  VirtualPayment
//
//  Created by 张博 on 2019/9/23.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGBaseModel.h"

NS_ASSUME_NONNULL_BEGIN

@class QGCanConfigTermsDetailModel, QGCanSelectTermModel, QGFixedTermDetailModel, QGLowestRepayDetailModel;

@interface QGConfigInstallmentPlanModel : QGBaseModel

/// 可配置分期
@property (nonatomic, strong) QGCanConfigTermsDetailModel * canConfigTermsDetail;

/// 固定分期方案
@property (nonatomic, strong) QGFixedTermDetailModel * fixedTermDetail;

/// 最低还款方案
@property (nonatomic, strong) QGLowestRepayDetailModel * lowestRepayDetail;

/**
* 用户分组类型
* 1: 可配置分期组
* 2: 固定分期组
* 3: 最低还款组
*/
@property (nonatomic, strong) NSString * userGroupEnumType;

@end


/// 可配置分期方案
@interface QGCanConfigTermsDetailModel : QGBaseModel
/**
* 消费分期小于10元 系统默认不分期
* 分期金额 阈值限制
*/
@property (nonatomic, strong) NSString * termAmountThreshold;

///可配置分期方案选项
@property (nonatomic, strong) NSArray <QGCanSelectTermModel *> * canSelectTerms;

/// 息费说明
@property (nonatomic, strong) NSString * canConfigTermContentFeeDesc;

/// 举例说明
@property (nonatomic, strong) NSString * canConfigTermContentEx;

/// 选中区域的高度
@property (nonatomic, assign) CGFloat headerCellHeight;

/// 描述区域的高度
@property (nonatomic, assign) CGFloat descCellHeight;
@end

///可配置分期方案选项
@interface QGCanSelectTermModel : QGBaseModel
/**
* 分 1 3 6 9 12 期
*/
@property (nonatomic, strong) NSString * term;
/**
* 每期对应的费率
*/
@property (nonatomic, strong) NSString * termRate;

/**
* 系统初始化默认选择 或 用户已选择的分期
*/
@property (nonatomic, assign) BOOL selectedTerm;
@end


/// 固定分期方案
@interface QGFixedTermDetailModel : QGBaseModel
/**
* 固定分期组  X期
*/
@property (nonatomic, strong) NSString * fixedTerm;
/**
* 固定分期组 费率
*/
@property (nonatomic, strong) NSString * fixedTermRate;
/**
* 固定分期组的示例文案 详情
*/
@property (nonatomic, strong) NSString * fixedTermContentEx;
/**
* 固定分期组的示例文案 标题
*/
@property (nonatomic, strong) NSString * fixedTermContentExTitle;

/**
* 固定分期组的示例文案 弹窗
*/
@property (nonatomic, strong) NSString * fixedTermContentFirstPopup;

@end


/// 最低还款
@interface QGLowestRepayDetailModel : QGBaseModel
/**
* 最低还款组的示例文案：文案示例说明
*/
@property (nonatomic, strong) NSString * lowestRepayContentEx;
/**
* 最低还款组的示例文案： 文案尾部
*/
@property (nonatomic, strong) NSString * lowestRepayContentTail;
/**
* 最低还款组的示例文案： 文案头部
*/
@property (nonatomic, strong) NSString * lowestRepayContentTitle;
/**
* 最低还款日费率 0.1%
*/
@property (nonatomic, strong) NSString * lowestRepayDailyFeeRate;
/**
* 最低还款费率 百分比   10%
*/
@property (nonatomic, strong) NSString * lowestRepayRate;
@end

NS_ASSUME_NONNULL_END
