//
//  CWWebViewController.m
//  CreditWallet
//
//  Created by mike on 15/5/11.
//  Copyright (c) 2015年 QuantGroup. All rights reserved.
//

#import "CWWebViewController.h"
@interface CWWebViewController () <UIAlertViewDelegate>

@end

@implementation CWWebViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self.myWebView stringByEvaluatingJavaScriptFromString:@"document.onpropertychange = function() {if (window.event.propertyName == 'title') {window.location = 'titlechanged://tralala';}};"];
}


- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];

    [self.myWebView stopLoading];
}

#pragma mark - UIWebViewDelegate

- (void)webViewDidStartLoad:(UIWebView *)webView {
    NSString *currentURL = webView.request.URL.absoluteString;
    [self popWhithSchemeString:currentURL];
}
- (void)webViewDidFinishLoad:(UIWebView *)webView {
    [super webViewDidFinishLoad:webView];

    NSString *currentURL = webView.request.URL.absoluteString;
    [self popWhithSchemeString:currentURL];
}
- (BOOL)webView:(UIWebView *)webView shouldStartLoadWithRequest:(NSURLRequest *)request navigationType:(UIWebViewNavigationType)navigationType {
    
    NSString *currentURL = request.URL.absoluteString;
    [self popWhithSchemeString:currentURL];

    return [super webView:webView shouldStartLoadWithRequest:request navigationType:navigationType];
}

- (void)webView:(UIWebView *)webView didFailLoadWithError:(NSError *)error {
    if (error) {
        NSString *currentURL = [error.userInfo objectForKey:@"NSErrorFailingURLStringKey"];
        ;
        [self popWhithSchemeString:currentURL];
    }
}

- (void)popWhithSchemeString:(NSString *)Str {
    if (Str.length > 0) {
        if (self.closeUrl.length == 0) {
            self.closeUrl = @"";
        }
        NSRange closeUrlRange = [Str rangeOfString:self.closeUrl];
        NSRange localhostRange = [Str rangeOfString:@"localhost"];
        if (closeUrlRange.location != NSNotFound || localhostRange.location != NSNotFound) {
            [self pop];
        }
    }
}


- (void)pop {
    [self.navigationController popViewControllerAnimated:YES];
}



- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

@end
