//
//  QGBindingWalletInfoSubCell.m
//  VirtualPayment
//
//  Created by 张博 on 2019/11/18.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGBindingWalletInfoSubCell.h"
#import "QGBasicUITool.h"
#import "UIImageView+QGWebCache.h"
@interface QGBindingWalletInfoSubCell ()

/// 教程图片
@property (nonatomic, strong) UIImageView * stepImageView;

/// 描述
@property (nonatomic, strong) UILabel * descLabel;

/// 步骤的位置
@property (nonatomic, strong, readwrite) UILabel * indexLabel;
@end

@implementation QGBindingWalletInfoSubCell

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        
        //教程图片
        self.stepImageView = [UIImageView creatImageViewWithSuperView:self imageName:nil];
        [self.stepImageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.offset(20);
            make.size.mas_equalTo(CGSizeMake(180, 185));
            make.centerX.offset(0);
        }];
        
        
        //步骤
        self.descLabel = [UILabel creatLabelWithSuperView:self title:nil titleFontSize:[UIFont qg_regularFontOfSize:12] textColor:[UIColor textColor9999] alignment:NSTextAlignmentCenter];
        [self.descLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerX.mas_equalTo(self).offset(10);
            make.right.mas_lessThanOrEqualTo(-20);
            make.top.mas_equalTo(self.stepImageView.mas_bottom).offset(3);
        }];
        
        //位置
        self.indexLabel = [UILabel creatLabelWithSuperView:self title:nil titleFontSize:[UIFont qg_mediumFontOfSize:10] textColor:[UIColor whiteColor] alignment:NSTextAlignmentCenter];
        self.indexLabel.layer.cornerRadius = 7;
        self.indexLabel.clipsToBounds = YES;
        self.indexLabel.backgroundColor = [UIColor colorWithHexString:@"D8D8D8"];
        [self.indexLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(14, 14));
            make.centerY.mas_equalTo(self.descLabel);
            make.right.mas_equalTo(self.descLabel.mas_left).offset(-5);
        }];
        
    }
    return self;
}


- (void)setStepModel:(QGStepImageModel *)stepModel
{
    if (_stepModel != stepModel) {
        _stepModel = stepModel;
        
        [self.stepImageView setImageByNomalPlaceholderWithURLString:_stepModel.stepImage];
        self.descLabel.text = _stepModel.stepDesc;
    }
}

@end
