//
//  QGBindingCardAlertView.m
//  VirtualPayment
//
//  Created by 张博 on 2019/11/18.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGBindingCardAlertView.h"
#import "QGBasicUITool.h"
#import "QGGradientShadowButton.h"
#import "QGAlertView.h"
@interface QGBindingCardAlertView ()
/// 标题
@property (nonatomic, strong) UILabel * titleLabel;

/// 内容展示
@property (nonatomic, strong) UIImageView * contentImageView;

/// 卡号
@property (nonatomic, strong, readwrite) QGPasteboardLabel * cardNumLabel;

/// 复制并打开按钮
@property (nonatomic, strong) QGGradientShadowButton * openButton;

@end


@implementation QGBindingCardAlertView


- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        
        self.popType = PopViewTypeActionSheet;
        //标题
        self.titleLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_regularFontOfSize:13] textColor:[UIColor textColor9999] alignment:NSTextAlignmentCenter];
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerX.offset(0);
            make.height.mas_equalTo(18);
            make.top.offset(17);
        }];
        
        
        //关闭
        UIButton * closeButton = [UIButton creatButtonWithSuperView:self.contentView title:nil titleFont:nil textColor:nil];
        [closeButton setImage:[UIImage imageNamed:@"cardlist_add_close"] forState:UIControlStateNormal];
        [closeButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.right.inset(0);
            make.size.mas_equalTo(CGSizeMake(50, 50));
        }];
        
        @weakify(self);
        [closeButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
            @strongify(self);
            [self dismissView:nil];
        }];
        
        //线
        UIView * lineView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor lineSeparatorColorDCDC]];
        [lineView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.mas_equalTo(self.titleLabel.mas_bottom).offset(16);
            make.left.right.inset(0);
            make.height.mas_equalTo(0.5);
        }];
        
        //内容展示
        self.contentImageView = [UIImageView creatImageViewWithSuperView:self.contentView imageName:nil];
        [self.contentImageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(convertEqualScaleFrom375(345), convertEqualScaleFrom375(188)));
            make.centerX.offset(0);
            make.top.mas_equalTo(lineView.mas_bottom).offset(40);
        }];
        
        //底部线条
        UIView * bottomLine = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor lineSeparatorColorDCDC]];
        [bottomLine mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.mas_equalTo(self.contentImageView.mas_bottom).offset(21);
            make.left.right.inset(20);
            make.height.mas_equalTo(0.5);
        }];
        
        //银行卡标题
        UILabel * cardTitle = [UILabel creatLabelWithSuperView:self.contentView title:@"银行卡号" titleFontSize:[UIFont qg_lightFontOfSize:14] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        [cardTitle mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(bottomLine);
            make.top.mas_equalTo(bottomLine.mas_bottom).offset(15);
            make.height.mas_equalTo(20);
        }];
        
        
        //卡号
        self.cardNumLabel = [[QGPasteboardLabel alloc] init];
        self.cardNumLabel.font = [UIFont qg_regularFontOfSize:14];
        self.cardNumLabel.textColor = [UIColor textColor3333];
        [self.contentView addSubview:self.cardNumLabel];
        self.cardNumLabel.isClearWhitespace = YES;
        [self.cardNumLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(20);
            make.height.mas_equalTo(20);
            make.centerY.mas_equalTo(cardTitle);
        }];
        
        //复制按钮
        self.openButton = [QGGradientShadowButton creatGradientColorButtonWithSuperView:self.contentView title:@"" textFont:[UIFont qg_regularFontOfSize:17]];
        [self.openButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.top.mas_equalTo(cardTitle.mas_bottom).offset(50);
            make.height.mas_equalTo(40);
            make.bottom.inset(25);
        }];
        
        

        /// 底部按钮跳转逻辑
        [self.openButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
            @strongify(self);
            
            // 复制文字到剪切板
            UIPasteboard * paste = [UIPasteboard generalPasteboard];
            NSString * resultText = [self.cardNumLabel.text stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
            resultText = [resultText stringByReplacingOccurrencesOfString:@" " withString:@""];
            paste.string = resultText;
            paste.strings = @[resultText];
            
            //弹窗
            if (self.alertViewType == BindingCardAlertViewTypeWechat) { // 微信
                NSURL *url = [NSURL URLWithString:@"weixin://"];
                if ([[UIApplication sharedApplication] canOpenURL:url]) {
                    [[UIApplication sharedApplication] openURL:url];
                }else{
                    QGAlertView *alert = [[QGAlertView alloc]initWithTitle:nil message:@"未检测到该手机的微信，请安装后重试或手动打开" cancelButtonTitle:nil sureButtonTitle:@"知道了" clickBlock:NULL];
                    [alert showInView:nil];
                }
            }else if (self.alertViewType == BindingCardAlertViewTypeAlipay){  // 支付宝
                
                NSURL *url = [NSURL URLWithString:@"alipay://"];
                if ([[UIApplication sharedApplication] canOpenURL:url]) {
                    [[UIApplication sharedApplication] openURL:url];
                }else{
                    QGAlertView *alert = [[QGAlertView alloc]initWithTitle:nil message:@"未检测到该手机的支付宝，请安装后重试或手动打开" cancelButtonTitle:nil sureButtonTitle:@"知道了" clickBlock:NULL];
                    [alert showInView:nil];
                }
                
            }
        }];
        
    }
    return self;
}


- (void)setAlertViewType:(BindingCardAlertViewType)alertViewType
{
    _alertViewType = alertViewType;
    if (_alertViewType == BindingCardAlertViewTypeAlipay) {
        self.contentImageView.image = [UIImage imageNamed:@"binding_alert_alipay"];
        self.titleLabel.text = @"添加到支付宝使用";
        [self.openButton setTitle:@"复制卡号并打开支付宝" forState:UIControlStateNormal];
    }
    else
    {
        self.contentImageView.image = [UIImage imageNamed:@"binding_alert_wechat"];
        self.titleLabel.text = @"添加到微信使用";
        [self.openButton setTitle:@"复制卡号并打开微信" forState:UIControlStateNormal];
    }
}






@end
