//
//  QGBindingWalletController.m
//  VirtualPayment
//
//  Created by 张博 on 2019/11/18.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGBindingWalletController.h"

//View
#import "QGBindingWalletBankCardCell.h"
#import "QGBindingWalletInfoCell.h"

//Model
#import "QGBindingWalletModel.h"

//Tool
#import "UIImageView+QGWebCache.h"
#import "QGCardRequestApi.h"
@interface QGBindingWalletController ()

/// 卡号
@property (nonatomic, strong) NSString * cardNo;

/// 添加到钱包教程
@property (nonatomic, strong) QGBindingWalletModel * walletModel;
@end

@implementation QGBindingWalletController

- (BOOL)checkParameters:(NSDictionary *)param
{
    if (param[@"cardNo"]) {
        return YES;
    }
    return NO;
}

- (void)transferParameters:(NSDictionary *)param
{
    self.cardNo = param[@"cardNo"];
}


- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    self.title = @"添加到手机钱包";
    [self custemLeftDefaultBarButtonItem];
    
    [self requestBindingWalletStep];
}



- (void)requestBindingWalletStep
{
//    NSString * urlStr = @"http://yapi.quantgroups.com/mock/169/vcc/mvp/bindWalletStep";
    NSString * urlStr = [QGCardRequestApi urlWithIndex:QGCardRequestServerMethodBindWalletStep];
    
    [QGHUDManager showHud:nil];
    [[QGTalosNetwork shareManager] GET:urlStr parameters:@{@"mobilePhoneBrand":@"apple"} success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            self.walletModel = [QGBindingWalletModel yy_modelWithJSON:responseObject[@"data"]];
            [self.tableView reloadData];
        }
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        NSString * errorMessage = [QGBaseNetwork getMessageWithFailureError:error];
        [QGHUDManager showHud:errorMessage];
    }];
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    //银行卡 + 教程
    return self.walletModel ? 2 : 0;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    //银行卡
    if (indexPath.row == 0) {
        QGBindingWalletBankCardCell * cell = (QGBindingWalletBankCardCell *)[self getCellFromClassName:NSStringFromClass([QGBindingWalletBankCardCell class]) dequeueTableView:tableView];
        cell.bankCardNumLabel.text = [self.cardNo formatterBankCardNum];
        [cell.bankCardImageView setImageByNomalPlaceholderWithURLString:self.walletModel.cardImage];
        return cell;
    }
    //教程
    else if (indexPath.row == 1)
    {
        QGBindingWalletInfoCell * cell = (QGBindingWalletInfoCell *)[self getCellFromClassName:NSStringFromClass([QGBindingWalletInfoCell class]) dequeueTableView:tableView];
        cell.walletModel = self.walletModel;
        cell.cardNum = self.cardNo;
        return cell;
    }
    
    return [UITableViewCell new];
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    CGFloat heightForRow = 0;
    //银行卡
    if (indexPath.row == 0) {
        heightForRow = [QGBindingWalletBankCardCell cellHeight];
    }
    else
    {
        heightForRow = 353;
    }
    return heightForRow;
}


@end
