//
//  QGActivityPopView.m
//  VirtualPayment
//
//  Created by silicn on 2019/12/9.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGActivityPopView.h"
#import "QGActivityPopModel.h"
#import "QGBasicUITool.h"
#import "UIImageView+WebCache.h"
#import "UIViewController+CommonConfig.h"

#import "QGAnalyticsService.h"

#import "QGApplicationOpenURL.h"


@interface QGActivityPopView ()

@property (nonatomic, strong,readwrite)QGActivityPopModel *popModel;
/// 展示图片的背景视图,圆角,交互
@property (nonatomic, strong)UIView *displayView;
/// 图片
@property (nonatomic, strong)UIImageView *displayIV;
/// 关闭按钮
@property (nonatomic, strong)UIButton *closeBtn;
/// 点击内容
@property (nonatomic, strong)UITapGestureRecognizer *popTap;

@end

@implementation QGActivityPopView

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
    }
    return self;
}

- (instancetype)initWithPopModel:(QGActivityPopModel *)model
{
    self = [super init];
    if (self) {
        self.popType = PopViewTypeAlert;
        self.contentView.backgroundColor = [UIColor clearColor];
        self.popModel = model;
        [self setups];
    }
    return self;
}

- (void)setups{
    
    /// 如果model是空的,则中断.用户至少可以点击灰色背景关闭弹窗.以防程序假死
    if (self.popModel == nil){
        [self dismissView:NULL];
        return;
    }
    self.dissMissClickBackground = NO;
    // 显示图片的View
    [self.contentView addSubview:self.displayView];
    // 添加手势
    [self.displayView addGestureRecognizer:self.popTap];
    
    [self.displayView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.right.equalTo(self.contentView);
        make.height.equalTo(self.displayView.mas_width).multipliedBy(390/290.0);
    }];
      // 要显示的图片ImageView
    [self.displayView addSubview:self.displayIV];
    [self.displayIV sd_setImageWithURL:[NSURL URLWithString:self.popModel.img]];
    self.displayIV.contentMode = UIViewContentModeScaleAspectFit;
    [self.displayIV mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self.displayView);
    }];
    // 根据数据类型布局关闭按钮的位置 1-代表右上 2-代表下方居中
    if (self.popModel.closeType == 1 && self.popModel.showClose) {
        [self addSubview:self.closeBtn];
        [self.closeBtn addTarget:self action:@selector(close) forControlEvents:UIControlEventTouchUpInside];
        [self.closeBtn setImage:[UIImage imageNamed:@"close_right"] forState:UIControlStateNormal];
        [self.closeBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.equalTo(self.mas_topMargin).inset(20);
            make.right.inset(20);
            make.height.width.equalTo(@40);
        }];
        [self.displayView mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.edges.equalTo(self.contentView);
            make.height.equalTo(self.displayView.mas_width).multipliedBy(390/290.0);
        }];
    }else if(self.popModel.closeType == 2 && self.popModel.showClose) {
        [self addSubview:self.closeBtn];
        [self.closeBtn setImage:[UIImage imageNamed:@"close_bottom"] forState:UIControlStateNormal];
        [self.closeBtn addTarget:self action:@selector(close) forControlEvents:UIControlEventTouchUpInside];
        [self.closeBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerX.equalTo(self.displayView);
            make.top.equalTo(self.displayView.mas_bottom).offset(45);
            make.bottom.equalTo(self.contentView).inset(16);
        }];
    }else{
        // 没有关闭按钮
        [self.displayView mas_remakeConstraints:^(MASConstraintMaker *make) {
              make.edges.equalTo(self.contentView);
              make.height.equalTo(self.displayView.mas_width).multipliedBy(390/290.0);
        }];
    }
}
/// 关闭操作
- (void)close
{
    [UIView animateWithDuration:0.25 animations:^{
               self.contentView.alpha = 0.0f;
               self.backgroundColor = [UIColor colorWithWhite:0 alpha:0];
    } completion:^(BOOL finished) {
       if (self.activityDismissBlock) {
           self.activityDismissBlock(self.position, self.popModel,self.controller,YES);
       }
        [self removeFromSuperview];
    }];
    self.showing = NO;
}

/// 点击内容关闭
- (void)clickContent
{
    [UIView animateWithDuration:0.25 animations:^{
             self.contentView.alpha = 0.0f;
             self.backgroundColor = [UIColor colorWithWhite:0 alpha:0];
    } completion:^(BOOL finished) {
        /// 不需要登录 || 需要登录并且已经登录
       if (self.popModel.needLogin == 0 || (self.popModel.needLogin == 1 && QGUserInfo.isLogin )) {
           /// 本地记录点击
           if (self.activityDismissBlock) {
               self.activityDismissBlock(self.position, self.popModel,self.controller,NO);
           }
           if (self.popModel.jumpUrl) {
               [QGApplicationOpenURL  handleAllSupportUrl:self.popModel.jumpUrl];
           }
           /// 统计
            [self activityClickanalytics];
           
            [self removeFromSuperview];
       }else{  /// 需要登录但是没登录 ,弹出登陆页面
           if (self.controller) {
               [self.controller showLoginViewControllerCompletion:^{
                   /// 只有登录完成才能记录点击
                   if (self.activityDismissBlock) {
                       self.activityDismissBlock(self.position, self.popModel,self.controller,NO);
                   }
                     if (self.popModel.jumpUrl) {
                         [QGApplicationOpenURL  handleAllSupportUrl:self.popModel.jumpUrl];
                     }
                   [self activityClickanalytics];
                }];
           }
           [self removeFromSuperview];
       }
      
    }];
    self.showing = NO;
}

- (void)showInView:(UIView *)superView
{
    [super showInView:superView];
    self.showing = YES;
}

/// 浮窗点击统计
- (void)activityClickanalytics
{
    QGAppCoreModelClickEvent *event = [QGAppCoreModelClickEvent acmcEventWithPage:[self pageNameWithIndex:self.position] path:nil name:nil detail_name:@"弹窗内容点击"];
    [QGAnalyticsService analyticsTrackWithEvent:event];
}

/// 根据index获取位置String
- (NSString *)pageNameWithIndex:(NSInteger)index
{
    if (index == 1) {
        return @"弹窗-首页";
    }
    if (index == 2) {
        return @"弹窗-管理页";
    }
    if (index == 3) {
        return @"弹窗-我的";
    }
    
    return nil;
}


- (UIView *)displayView
{
    if (_displayView == nil) {
        _displayView = [[UIView alloc]init];
        _displayView.backgroundColor = [UIColor clearColor];
        _displayView.layer.cornerRadius = 8;
        _displayView.clipsToBounds = YES;
    }
    return _displayView;
}

- (UIImageView *)displayIV
{
    if (_displayIV == nil) {
        _displayIV = [[UIImageView alloc]init];
        _displayIV.backgroundColor = [UIColor clearColor];
    }
    return _displayIV;
}

- (UIButton *)closeBtn
{
    if (_closeBtn == nil) {
        _closeBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    }
    return _closeBtn;
}

- (UITapGestureRecognizer *)popTap
{
    if (_popTap == nil) {
        _popTap = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(clickContent)];
    }
    return _popTap;
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
