//
//  QGActivityPopView.h
//  VirtualPayment
//
//  Created by silicn on 2019/12/9.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGBasePopView.h"

@class QGActivityPopModel,QGActivityPopView;

typedef void(^QGActivityDismissBlock)(NSInteger position,QGActivityPopModel * _Nonnull popModel,UIViewController * _Nonnull controller ,BOOL isClose);

typedef void (^QGActivityShouldWaitBlock)(QGActivityPopView * _Nullable pop);

NS_ASSUME_NONNULL_BEGIN

@interface QGActivityPopView : QGBasePopView

/// 是否正在显示
@property (nonatomic, assign) BOOL showing;
///位置
@property (nonatomic, assign)NSInteger position;
///在哪个类显示
@property (nonatomic, strong)UIViewController *controller;
///model
@property (nonatomic, strong,readonly)QGActivityPopModel *popModel;

/// 指定初始化方法,如果model = nil 则视图立刻消失
/// @param model 活动内容model
- (instancetype)initWithPopModel:(nonnull QGActivityPopModel *)model ;

@property (nonatomic,copy)QGActivityDismissBlock activityDismissBlock;

@end

NS_ASSUME_NONNULL_END
