//
//  QGActivityPopModel.h
//  VirtualPayment
//
//  Created by silicn on 2019/12/9.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGBaseModel.h"

NS_ASSUME_NONNULL_BEGIN

@interface QGActivityPopModel : QGBaseModel

/*
   此model分别对应弹窗和浮窗
 */

/// 活动标识-唯一,用于区分不同的活动
@property (nonatomic, copy)NSString *uniqueId;
/// 显示图片地址
@property (nonatomic, copy) NSString *img ;
/// 跳转地址
@property (nonatomic, copy) NSString *jumpUrl ;
/// 弹窗点击规则 1-点击后不再弹出  2-关闭后不再弹出 3-每天弹出一次 4-每次启动弹出
/// 浮窗规则 1-点击后不再显示 2-一直显示
@property (nonatomic, assign) NSInteger showType;
/// 是否显示关闭按钮 0-不显示  1-显示
@property (nonatomic, assign) NSInteger showClose;
/// 关闭按钮类型 1-右上角关闭 2-下方居中关闭
@property (nonatomic, assign) NSInteger closeType;
/// 活动名称
@property (nonatomic, copy) NSString *name;
/// 登录，1登录展示，0不登录展示
@property (nonatomic, assign) NSInteger needLogin;

/// 浮窗显示的位置 1-右上 2-右中 3-右下
@property (nonatomic, assign) NSInteger position;

@property (nonatomic, assign)NSInteger loginStatus;

@end

NS_ASSUME_NONNULL_END
