//
//  QGActivityPopManager.h
//  VirtualPayment
//
//  Created by silicn on 2019/12/10.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger,QGActivityPosition)
{
    QGActivityPositionHome = 1,  // 首页活动弹窗
    QGActivityPositionManager,   // 额度管理活动弹窗
    QGActivityPositionMine,      // 我的页面活动弹窗
    QGActivityPositionMall,      // 省钱模块
    QGActivityPositionCashback,  // 返现首页
    QGActivityPositionAll = 9    // 所有活动弹窗
};

@interface QGActivityPopManager : NSObject

/// 便利构造器
+ (instancetype)shareInstance;

/// 因为弹窗会发生变化,去掉这个初始化
///// 展示某个位置的活动弹窗
///// @param position 位置
///// @param controller 承载弹窗的父控制器
//- (void)showActivitiesAtPosition:(QGActivityPosition)position inController:(UIViewController *)controller;

/// 如果包含多个弹窗,在ViewController的viewDidAppear调用此方法
- (void)viewDidAppearAtPosition:(QGActivityPosition)position inController:(UIViewController *)controller;



@end

NS_ASSUME_NONNULL_END
