
//
//  QGIncreaseAmountHeaderView.m
//  VirtualPayment
//
//  Created by 张博 on 2019/6/27.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGIncreaseAmountHeaderView.h"
#import "QGBasicUITool.h"
#import "UIView+Extend.h"


@interface QGIncreaseAmountHeaderView ()

/**
 标题
 */
@property (nonatomic, strong) UILabel * titleLabel;

/**
 额度
 */
@property (nonatomic, strong) UILabel * amountLabel;

/**
 状态图
 */
@property (nonatomic, strong) UIImageView * statusImageView;
@end

@implementation QGIncreaseAmountHeaderView

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        
        //设置背景色
        self.backgroundColor = [UIColor moduleSeparatorColorF7F7];
        //背景框
        UIView * bgView = [self setupBackgroundView];
        
        //描述按钮
        UILabel * descLabel = [UILabel creatLabelWithSuperView:self title:@"每多认证一种，平均额度提升约30%，现在认证尊享极速审核" titleFontSize:[UIFont qg_regularFontOfSize:11] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        descLabel.numberOfLines = 0;
        [descLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.offset(20);
            make.top.mas_equalTo(bgView.mas_bottom).offset(0);
            make.bottom.mas_offset(0);
        }];
        
        
    }
    return self;
}

- (UIView *)setupBackgroundView
{
    //背景框
    UIView * bgView = [UIView creatViewWithSuperView:self backgroundColor:[UIColor whiteColor]];
    bgView.layer.cornerRadius = 3;
    bgView.clipsToBounds = YES;
    [bgView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.right.inset(20);
        make.height.mas_equalTo(120);
    }];
    
    //图片
    self.statusImageView = [UIImageView creatImageViewWithSuperView:bgView imageName:nil];
    [self.statusImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.bottom.top.offset(0);
    }];
    self.statusImageView.contentMode = UIViewContentModeScaleToFill;
    
    //标题
    self.titleLabel = [UILabel creatLabelWithSuperView:bgView title:@"最高可提升至五万" titleFontSize:[UIFont qg_mediumFontOfSize:25] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
    [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_offset(25);
        make.left.right.mas_offset(20);
        make.height.mas_equalTo(36);
    }];
    
    //额度
    self.amountLabel = [UILabel creatLabelWithSuperView:bgView title:nil titleFontSize:[UIFont qg_regularFontOfSize:14] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
    [self.amountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.mas_offset(20);
        make.top.mas_equalTo(self.titleLabel.mas_bottom).offset(10);
        make.height.mas_equalTo(20);
    }];
    
    return bgView;
}


- (void)setDataModel:(QGIncreaseAmountModel *)dataModel
{
    if (_dataModel != dataModel) {
        _dataModel = dataModel;
        
        //完成所有的认证
        if (_dataModel.finishAll.boolValue) {
            self.titleLabel.text = @"恭喜您已完成全部认证";
            self.amountLabel.text = [NSString stringWithFormat:@"我的额度(元):%@元",_dataModel.amount];
            self.statusImageView.image = [UIImage imageNamed:@"increaseAmount_header_finish"];
        }
        else
        {
            self.titleLabel.text = @"最高可提升至五万";
            self.amountLabel.text = [NSString stringWithFormat:@"我的额度(元):%@元",_dataModel.amount ? _dataModel.amount : @"0"];
            self.statusImageView.image = [UIImage imageNamed:@"increaseAmount_header_normal"];
        }
        
    }
}





@end
