//
//  QGIncreaseAmountCollectionViewCell.m
//  VirtualPayment
//
//  Created by 张博 on 2019/6/27.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGIncreaseAmountCollectionViewCell.h"

#import "QGBasicUITool.h"
#import "UIView+Layer.h"
@interface QGIncreaseAmountCollectionViewCell ()

@property (nonatomic, strong) UIView * bgView;
/**
 标题
 */
@property (nonatomic, strong) UILabel * titleLabel;

/**
 状态 (最高可提升/已完成/未完成)
 */
@property (nonatomic, strong) UILabel * statusLabel;

/**
 状态图 审核中/已完成
 */
@property (nonatomic, strong) UIImageView * statusImageView;

/**
 附加字段 待审核的金额 + 敬请期待
 */
@property (nonatomic, strong) UILabel * extLabel;

@end


@implementation QGIncreaseAmountCollectionViewCell

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        //背景视图
        self.bgView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor moduleSeparatorColorF7F7]];
        [self.bgView setShadowColor:[[UIColor textColor9999] colorWithAlphaComponent:.5] shadowRadius:4 shadowOffset:CGSizeMake(0, 2) cornerRadius:8];
        [self.bgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.bottom.left.right.mas_offset(2);
        }];
        
        //标题
        self.titleLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_regularFontOfSize:14] textColor:[UIColor textColor3333] alignment:NSTextAlignmentCenter];
        
        //子标题
        self.statusLabel = [UILabel creatLabelWithSuperView:self.contentView title:@"最高可提升" titleFontSize:[UIFont qg_lightFontOfSize:12] textColor:[UIColor textColor9999] alignment:NSTextAlignmentCenter];
        
        //状态图
        self.statusImageView = [UIImageView creatImageViewWithSuperView:self.contentView imageName:nil];
        
        //待审核的金额 + 敬请期待
        self.extLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_regularFontOfSize:12] textColor:[UIColor textColor9999] alignment:NSTextAlignmentCenter];
        
    }
    return self;
}


- (void)setInfoModel:(QGCreditInfoModel *)infoModel
{
    if (_infoModel != infoModel) {
        _infoModel = infoModel;
        
        self.titleLabel.text = infoModel.creditName;
        
        //finished/await/crediting/unopen（已完成/待完成/提额中/未开放）
        //已完成  //提额中
        if ([_infoModel.creditStatus isEqualToString:@"finished"] || [_infoModel.creditStatus isEqualToString:@"crediting"]) {
            
            //更新约束位置
            [self.titleLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.left.right.inset(5);
                make.centerY.equalTo(self.contentView.mas_centerY).offset(-25);
                make.height.mas_equalTo(20);
            }];
            
            [self.statusImageView mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.size.mas_equalTo(CGSizeMake(24, 24));
                make.centerX.mas_offset(0);
                make.top.equalTo(self.titleLabel.mas_bottom).offset(11);
            }];
            
            [self.statusLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.left.right.inset(5);
                make.top.equalTo(self.statusImageView.mas_bottom).offset(3);
                make.height.mas_equalTo(17);
            }];
            
            self.statusImageView.hidden = NO;
            self.statusLabel.hidden = NO;
            self.extLabel.hidden = YES;
            
            //更新展示内容
            if ([_infoModel.creditStatus isEqualToString:@"finished"]) {
                self.statusImageView.image = [UIImage imageNamed:@"IncreaseAmount_creditStatus_finished"];
            }
            else
            {
                self.statusImageView.image = [UIImage imageNamed:@"IncreaseAmount_creditStatus_crediting"];
            }
            self.statusLabel.text = _infoModel.creditDesc;
        }
        //待完成
        else if ([_infoModel.creditStatus isEqualToString:@"await"])
        {
            //更新约束位置
            [self.titleLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.left.right.inset(5);
                make.top.mas_offset(20);
                make.height.mas_equalTo(20);
            }];
            
            [self.statusLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.left.right.inset(5);
                make.top.mas_offset(56);
                make.height.mas_equalTo(17);
            }];
            
            [self.extLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.left.right.inset(5);
                make.top.mas_offset(78);
                make.height.mas_equalTo(17);
            }];
            
            self.statusImageView.hidden = YES;
            self.statusLabel.hidden = NO;
            self.extLabel.hidden = NO;
            
            //更新展示内容
            self.statusLabel.text = _infoModel.creditDesc;
            if ([NSString isEmpty:infoModel.ext.maxAmount]) {
                self.extLabel.text = @"";
            }
            else
            {
                self.extLabel.text = [NSString stringWithFormat:@"¥%@",infoModel.ext.maxAmount];
            }
            self.extLabel.textColor = [UIColor textColor3333];
        }
        //未开放
        else if ([_infoModel.creditStatus isEqualToString:@"unopen"])
        {
            //更新约束位置
            [self.titleLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.left.right.inset(5);
                make.top.mas_offset(37);
                make.height.mas_equalTo(20);
            }];
            
            [self.extLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.left.right.inset(5);
                make.top.mas_offset(61);
                make.height.mas_equalTo(17);
            }];
            
            self.statusImageView.hidden = YES;
            self.statusLabel.hidden = YES;
            self.extLabel.hidden = NO;
            //更新展示内容
            self.extLabel.text = @"敬请期待";
            self.extLabel.textColor  = [UIColor textColor9999];
        }
        
        //修改背景颜色
        //待完成
        if ([_infoModel.creditStatus isEqualToString:@"await"]) {
            self.bgView.backgroundColor = [UIColor whiteColor];
            self.bgView.layer.shadowOpacity = 0.5;
        }
        else
        {
            self.bgView.backgroundColor = [UIColor moduleSeparatorColorF7F7];
            self.bgView.layer.shadowOpacity = 0;
        }
        
        
    }
}

@end
