//
//  QGCreditInfoModel.h
//  VirtualPayment
//
//  Created by 张博 on 2019/6/27.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGBaseModel.h"
@class QGExtModel,QGCreditInfoModel;
NS_ASSUME_NONNULL_BEGIN

@interface QGIncreaseAmountModel : QGBaseModel

/**
 总额
 */
@property (nonatomic, strong) NSString * amount;

/**
 授信信息数组
 */
@property (nonatomic, strong) NSArray <QGCreditInfoModel *>* creditInfos;

/**
 是否做完所有提额项
 */
@property (nonatomic, strong) NSString * finishAll;
@end


/**
 授信信息
 */
@interface QGCreditInfoModel : QGBaseModel

/**
 描述
 */
@property (nonatomic, strong) NSString * creditDesc;

/**
 标题
 */
@property (nonatomic, strong) NSString * creditName;

/**
 finished/await/crediting/unopen（已完成/待完成/提额中/未开放）
 */
@property (nonatomic, strong) NSString * creditStatus;

/**
 授信URL
 */
@property (nonatomic, strong) NSString * creditUrl;
@property (nonatomic, strong) QGExtModel * ext;
@end


@interface QGExtModel : QGBaseModel

/**
 "待完成" 显示 maxAmount 数据状态
 */
@property (nonatomic, strong) NSString * maxAmount;
@end

NS_ASSUME_NONNULL_END
