//
//  AppDelegate.m
//  VirtualPayment
//
//  Created by 张博 on 2019/5/5.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "AppDelegate.h"
#import "QGRootTabbarController.h"

//神策
#import "QGAnalyticsService.h"
#import "SensorsAnalyticsSDK.h"

#import "QGBaiChuanManager.h"

#import "SystemManager.h"
#import "QGRiskInfoManager.h"
#import "QGWindowManager.h"
#import "QGUserInfo.h"
#import "QGPushService.h"
#import "QGToolsConfig.h"
#import "QGAppMacro.h"
#import "QGThirdPlatformService.h"
#import "QGApplicationOpenURL.h"
#import "QGDefaultLaunchViewController.h"
#ifdef NSFoundationVersionNumber_iOS_9_x_Max
#import <UserNotifications/UserNotifications.h>
#endif

#import "ByteInsights.h"
@interface AppDelegate ()

@end

@implementation AppDelegate



- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    
    //注册神策统计，只有注册了神策后，神策统计才会生效
    [QGAnalyticsService sensorsAnalyticsWithOptions:launchOptions];
    
    //1.创建Window
    self.window = [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];
    self.window.backgroundColor = [UIColor whiteColor];
    [self refreshTokenFinishWithOptions:launchOptions];
    //2.设置Window为主窗口并显示出来
    [self.window makeKeyAndVisible];
    return YES;
}

/// 刷新token接口是最大的接口，优先请求
- (void)refreshTokenFinishWithOptions:(NSDictionary *)launchOptions
{
    //刷新token
    [[SystemManager shareInstance] refreshTokenWithSuccess:nil failure:nil];
    
    QGRootTabbarController * tabbar = [[QGRootTabbarController alloc] init];
    self.window.rootViewController = tabbar;
    //友盟统计
    [QGAnalyticsService umengTrack];
    //初始化字节跳动APM
    [ByteInsights startWith:ByteDanceApmAppID channel:appChannel];
    //注册Push
    [QGPushService loadQGPushConfig:launchOptions];
    //自定义webviewUserAgent
    [SystemManager custemWebViewUserAgent];
    //检测升级
    [[SystemManager shareInstance] checkIsNeedUpdate];
    //上传IDFA
    [QGRiskInfoManager uploadUserIDFA];
    //检查是否展示前置window
    [QGWindowManager checkIsNeedShowFrontWindow];
    ///注册百川SDK
    [[QGBaiChuanManager shareInstance] registerBaiChuanSDK];
}


- (void)applicationWillResignActive:(UIApplication *)application {
    // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
    // Use this method to pause ongoing tasks, disable timers, and invalidate graphics rendering callbacks. Games should use this method to pause the game.
}


- (void)applicationDidEnterBackground:(UIApplication *)application {
    //清空应用图标的BadgeNumber
    [QGPushService clearApplicationIconBadgeNumber];
}

- (void)application:(UIApplication *)app didRegisterForRemoteNotificationsWithDeviceToken:(NSData *)deviceToken
{
    // 注册APNS成功, 注册deviceToken
    [QGPushService bindDeviceToken:deviceToken];
}

- (void)application:(UIApplication *)application didFailToRegisterForRemoteNotificationsWithError:(NSError *)error
{
    
}

- (void)applicationWillEnterForeground:(UIApplication *)application {
    // Called as part of the transition from the background to the active state; here you can undo many of the changes made on entering the background.
}


- (void)applicationDidBecomeActive:(UIApplication *)application {
    // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
    //检查粘贴板
    [[SystemManager shareInstance] checkPasteboard];
}


- (void)applicationWillTerminate:(UIApplication *)application {
    // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
}


- (BOOL)application:(UIApplication *)application openURL:(NSURL *)url sourceApplication:(NSString *)sourceApplication annotation:(id)annotation {
    /// 百川处理
    BOOL result = [[QGBaiChuanManager shareInstance] application:application openURL:url sourceApplication:sourceApplication annotation:annotation];
    if (!result) {
        /// 微信支付宝
        result = [[QGThirdPlatformService shareInstance] handleOpenURL:url delegate:self];
    }
    
    if (!result) {
        /// scheme
         result = [QGApplicationOpenURL handleSchemeUrl:url];
    }
    
    return result;
}

- (BOOL)application:(UIApplication *)app openURL:(NSURL *)url options:(NSDictionary<NSString *, id> *)options {
    /// 百川处理
    BOOL result = [[QGBaiChuanManager shareInstance] application:app openURL:url options:options];
    if (!result) {
        /// 微信支付宝处理
        result = [[QGThirdPlatformService shareInstance] handleOpenURL:url delegate:self];
    }
       
    if (!result) {
        /// scheme
        result = [QGApplicationOpenURL handleSchemeUrl:url];
    }
    
    if ([[SensorsAnalyticsSDK sharedInstance] handleSchemeUrl:url]) {
           return YES;
       }
    
    return result;
}

- (void)application:(UIApplication *)application didReceiveRemoteNotification:(NSDictionary *)userInfo {
    [QGPushService handleRemoteNotification:userInfo];
}

#pragma mark - iOS 10 以上方法
#ifdef NSFoundationVersionNumber_iOS_9_x_Max


//神策关于推送消息的模块
// iOS 10 Support
- (void)userNotificationCenter:(UNUserNotificationCenter *)center willPresentNotification:(UNNotification *)notification withCompletionHandler:(void (^)(UNNotificationPresentationOptions))completionHandler API_AVAILABLE(ios(10.0)){
    // Required
    NSDictionary * userInfo = notification.request.content.userInfo;
    if([notification.request.trigger isKindOfClass:[UNPushNotificationTrigger class]]) {
        [QGPushService handleRemoteNotification:userInfo];
    }
    
    // 收到了推送消息，使用神策分析追踪 "App 消息推送成功" 事件
    [[SensorsAnalyticsSDK sharedInstance] track:@"AppReceivedNotification" withProperties:@{
                                                                                            @"msg_title":[NSString stringWithFormat:@"%@",userInfo[@"aps"][@"alert"]],
                                                                                            @"msg_id":[NSString stringWithFormat:@"%@",userInfo[@"_id_"]]
                                                                                            }];
    // 直接上报数据
    [[SensorsAnalyticsSDK sharedInstance] flush];
    completionHandler(UNNotificationPresentationOptionBadge|UNNotificationPresentationOptionSound|UNNotificationPresentationOptionAlert); // 需要执行这个方法，选择是否提醒用户，有Badge、Sound、Alert三种类型可以设置
    
}
// iOS 10 Support
- (void)userNotificationCenter:(UNUserNotificationCenter *)center didReceiveNotificationResponse:(UNNotificationResponse *)response withCompletionHandler:(void (^)(void))completionHandler API_AVAILABLE(ios(10.0)){
    // Required
    NSDictionary * userInfo = response.notification.request.content.userInfo;
    if([response.notification.request.trigger isKindOfClass:[UNPushNotificationTrigger class]]) {
        [QGPushService handleRemoteNotification:userInfo];
    }
    // 用户点击通知栏打开消息，使用收到推送消息类似的方法，使用神策分析记录 "App 打开消息" 事件
    
    // 直接上报数据
    [[SensorsAnalyticsSDK sharedInstance] flush];
    completionHandler();  // 系统要求执行这个方法
}
#endif

@end
