//Jenkins防系统库编译出错自动添加 
#import <UIKit/UIKit.h> 
//Jenkins防系统库编译出错自动添加 
//
//  ByteInsights.h
//  ByteAPM
//
//  Created by yuanzhangjing on 2019/10/7.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface ByteInsights : NSObject

+(void)startWith:(NSString *)appID channel:(NSString *)channel;

+(void)startWith:(NSString *)appID channel:(NSString *)channel oversea:(BOOL)oversea;

@property (atomic, copy, class) NSString *userID;/**用户ID */
@property (atomic, copy, class) NSString *userName;/**用户名 */
@property (atomic, copy, class) NSString *email;/**用户邮箱 */

/**
 添加自定义的环境变量
 
 @param value 自定义的环境变量的值
 @param key 自定义的环境变量的键
 */
+ (void)setCustomContextValue:(id)value forKey:(NSString *)key;

/**
 移除自定义的环境变量
 
 @param key 自定义的环境变量的键
 */
+ (void)removeCustomContextKey:(NSString *)key;

/**
 添加自定义的筛选项
 
 @param value 自定义的筛选项的值
 @param key 自定义的筛选项的的键
 */
+ (void)setCustomFilterValue:(id)value forKey:(NSString *)key;

/**
 移除自定义的筛选项
 
 @param key 自定义的筛选项的键
 */
+ (void)removeCustomFilterKey:(NSString *)key;

@end

NS_ASSUME_NONNULL_END
