//
//  ZHJSContextHelper.m
//  PhysicianAssistant
//
//  Created by zhangbo on 16/5/24.
//  Copyright © 2016年 zhangbo. All rights reserved.
//

#import "ZHJSContextHelper.h"

@protocol ZHJSContextHelperJSExport <JSExport>

/**
 *  关闭页面
 */
JSExportAs(closeBrowser, -(void) JSCallOCMethodCloseBrowser
           : (id) value);

/**
 关闭当前页面，并重新打开一个新的协议
 */
JSExportAs(reopenBrowserWithNewUrl, -(void)JSCallOCMethodReopenBrowserWithNewUrl:(id)value);

/**
 VCC 模块操作类型：还款完成、分期完成等

 @param vccRepaymentActionType 操作类型type
 */
JSExportAs(vccRepaymentReload, -(void)JSCAllOCMethodVCCRepaymentReload:(id)value);

/// JS与native通用交互规则
/// @param payDic 传参
JSExportAs(xyqbJSEvent, - (void)JSCallOCMethodJSEvent:(NSDictionary *)eventDic);

@end

@interface ZHJSContextHelper () <ZHJSContextHelperJSExport>

@end

@implementation ZHJSContextHelper



//关闭浏览器
- (void)JSCallOCMethodCloseBrowser:(id)value {
    self.webviewThread = [NSThread currentThread];
    __weak typeof(self) weakSelf = self;
    dispatch_async(dispatch_get_main_queue(), ^{
        if (weakSelf.delegate && [self.delegate respondsToSelector:@selector(JSCallOCMethodCloseBrowser:)]) {
            [weakSelf.delegate JSCallOCMethodCloseBrowser:value];
        }
    });
}


/**
 关闭当前页面，并重新打开一个新的协议
 */
-(void)JSCallOCMethodReopenBrowserWithNewUrl:(id)value
{
    self.webviewThread = [NSThread currentThread];
    __weak typeof(self) weakSelf = self;
    dispatch_async(dispatch_get_main_queue(), ^{
        if (weakSelf.delegate && [self.delegate respondsToSelector:@selector(JSCallOCMethodReopenBrowserWithNewUrl:)]) {
            [weakSelf.delegate JSCallOCMethodReopenBrowserWithNewUrl:value];
        }
    });
}

-(void)JSCAllOCMethodVCCRepaymentReload:(id)value
{
    self.webviewThread = [NSThread currentThread];
    __weak typeof(self) weakSelf = self;
    dispatch_async(dispatch_get_main_queue(), ^{
        if (weakSelf.delegate && [self.delegate respondsToSelector:@selector(JSCAllOCMethodVCCRepaymentReload:)]) {
            [weakSelf.delegate JSCAllOCMethodVCCRepaymentReload:value];
        }
    });
}


/// JS与native通用交互规则
- (void)JSCallOCMethodJSEvent:(NSDictionary *)eventDic
{
    self.webviewThread = [NSThread currentThread];
       __weak typeof(self) weakSelf = self;
       dispatch_async(dispatch_get_main_queue(), ^{
           if (weakSelf.delegate && [self.delegate respondsToSelector:@selector(JSCallOCMethodJSEvent:)]) {
               [weakSelf.delegate JSCallOCMethodJSEvent:eventDic];
           }
       });
}

- (void)dealloc {
    NSLog(@"_____%@ dealloc", self);
}
@end

