//
//  ZHJSContextHelper.h
//  PhysicianAssistant
//
//  Created by zhangbo on 16/5/24.
//  Copyright © 2016年 zhangbo. All rights reserved.
//  http://www.zhimengzhe.com/IOSkaifa/3237.html

#import <JavaScriptCore/JavaScriptCore.h>
#import <UIKit/UIKit.h>

@protocol ZHJSContextHelperDelegate <NSObject>

@optional


//关闭浏览器
- (void)JSCallOCMethodCloseBrowser:(id)value;

///关闭当前页面，并重新打开一个新的协议
-(void)JSCallOCMethodReopenBrowserWithNewUrl:(id)value;

//VCC 模块操作类型:还款完成、分期完成等
-(void)JSCAllOCMethodVCCRepaymentReload:(id)value;

/// JS与native通用交互规则
- (void)JSCallOCMethodJSEvent:(NSDictionary *)eventDic;

@end

@interface ZHJSContextHelper : NSObject

@property (nonatomic, weak) id<ZHJSContextHelperDelegate> delegate;

/**
 每次JS调用OC时记录当前线程
 ps:经过测试发现，在同一个app生命周期内，打开不同的web页，内存地址一样
 */
@property (nonatomic, strong) NSThread *webviewThread;
@end

