//
//  SystemManager.h
//  CreditWallet
//
//  Created by 张博 on 16/8/26.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//




#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "QGRootTabbarController.h"
@interface SystemManager : NSObject

///记录当前所在的Nav
@property (nonatomic, weak) UINavigationController * currentNav;

///记录当前所在的ViewController
@property (nonatomic, weak) UIViewController * currentViewController;

///记录当前所使用的tabbar
@property (nonatomic, weak) QGRootTabbarController * tabbarController;


/**
 *  唯一初始化方法
 */
+ (instancetype)shareInstance;


/*************************/


/// 刷新token接口，内部判断登录状态下每日调用一次接口
/// @param successBlock 成功回调
/// isSuccess = YES 请求成功并且业务处理成功，token可用  场景：当日已经刷新过 | 首次刷新成功时调用（状态码为0000）
/// isSuccess = NO 请求成功业务处理失败，token不可用 场景：状态码非0000
/// @param failureBlock 网络请求失败回调
- (void)refreshTokenWithSuccess:(void(^)(BOOL isSuccess, NSString * token))successBlock failure:(void(^)(NSError * error))failureBlock;


/// 检查升级
- (void)checkIsNeedUpdate;

/// 检查粘贴板
- (void)checkPasteboard;

/*************************/
/**
 自定义webviewUserAgent
 */
+(void)custemWebViewUserAgent;

/**
 保存默认的user-agent
 */
+ (void)saveNormalUserAgent;

/**
 重置为默认的user-agent
 */
+ (void)resetToNormalUserAgent;
/*************************/



/**
 获取当前主Window
 */
+ (UIWindow *)getKeyWindow;

/**
 获取键盘高度
 */
+ (CGFloat)visibleKeyboardHeight;


@end
