//
//  ZHWeChatTool.h
//  CreditWallet
//
//  Created by 张博 on 16/9/2.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "QGBaseModel.h"

/// 微信登录信息模型
@interface QGWechatLoginInfoModel : QGBaseModel

/// 普通用户个人资料填写的城市
@property (nonatomic, strong) NSString * city;

/// 国家，如中国为 CN
@property (nonatomic, strong) NSString * country;

/// 普通用户个人资料填写的省份
@property (nonatomic, strong) NSString * province;

/// 用户头像，最后一个数值代表正方形头像大小（有 0、46、64、96、132 数值可选，0 代表 640*640 正方形头像），用户没有头像时该项为空
@property (nonatomic, strong) NSString * headimgurl;

/// 语言
@property (nonatomic, strong) NSString * language;

/// 昵称
@property (nonatomic, strong) NSString * nickname;

/// 普通用户的标识，对当前开发者帐号唯一
@property (nonatomic, strong) NSString * openid;

/// 普通用户性别，1 为男性，2 为女性
@property (nonatomic, strong) NSString * sex;

/// 用户统一标识。针对一个微信开放平台帐号下的应用，同一用户的 unionid 是唯一的。
@property (nonatomic, strong) NSString * unionid;

@end


//#import "WXApi.h"
///支付回调
typedef void(^ZHWeChatPayBlock)(BOOL isSuccess, NSString * errorMsg);
///分享回调
typedef void(^ZHWeChatShareResultBlock)(BOOL isSuccess);

//登录回调
typedef void(^ZHWeChatAuthSuccessBlock)(QGWechatLoginInfoModel * infoModel);

//-----------------------------------------------------------------------/

@interface ZHWeChatTool : NSObject
/**
 *  支付回调Block
 */
@property (nonatomic, copy) ZHWeChatPayBlock wxPayBlock;
/**
 *  分享回调Block
 */
@property (nonatomic, copy) ZHWeChatShareResultBlock wxShareResultBlock;

/// 登录成功回调
@property (nonatomic, copy) ZHWeChatAuthSuccessBlock authSuccessBlock;

//-----------------------------------------------------------------------/

/**
 *  唯一指定初始化方法 内部会自动注册微信APP ID
 */
+(instancetype)share;



/**
 *  微信是否安装
 *
 *  @return BOOL结果
 */
- (BOOL)isWXInstalled;


/// 打开微信APP
- (BOOL)openWXApp;

/// 微信登录
- (void)WXLogin;

/**
 *  微信分享多媒体信息
 *
 *  @param dic   字典内包含的key @[imgUrl,image,title,desc,link]
 *  @param scene  发送的目标场景，可以选择发送到会话(WXSceneSession)或者朋友圈(WXSceneTimeline)。 默认发送到会话。
 */
-(void)WXShareWithDic:(NSDictionary *)dic scene:(int)scene;

/// 微信图片分享
/// @param dic 分析字典
/// @param scene 发送的目标场景，可以选择发送到会话(WXSceneSession)或者朋友圈(WXSceneTimeline)。 默认发送到会话。
- (void)WXShareImageObjectWithDic:(NSDictionary *)dic scene:(int)scene;

/**
 *  分享文本到微信
 *  @param text  文本信息
 *  @param scene 发送的目标场景，可以选择发送到会话(WXSceneSession)或者朋友圈(WXSceneTimeline)。 默认发送到会话
 */
- (void)shareTextToWXWithText:(NSString *)text scene:(int)scene;


/**
 *  微信支付
 *
 *  @param payInfoDic   微信支付需要的必穿参数
 *  @param successBlock 支付回调
 */
- (void)WXPayWithPayinfoDic:(NSDictionary *)payInfoDic result:(void(^)(BOOL isSuccess))successBlock;



/*! @brief 处理微信通过URL启动App时传递的数据
 *
 * 需要在 application:openURL:sourceApplication:annotation:或者application:handleOpenURL中调用。
 * @param url 微信启动第三方应用时传递过来的URL
 * @return 成功返回YES，失败返回NO。
 */
- (BOOL)handleOpenURL:(NSURL *) url;

@end



