//
//  QGThirdPlatformService.m
//  CreditWallet
//
//  Created by 张博 on 16/9/2.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import "QGThirdPlatformService.h"
#import "ZHWeChatTool.h"
#import "QGTencentTool.h"

#import "WXApi.h"
#import "NSString+CreditWallet.h"
#import "QGAppMacro.h"
#import "QGHUDManager.h"
static QGThirdPlatformService * shareService = nil;
@implementation QGThirdPlatformService
/**
 *  唯一官方指定初始化方法
 *
 *  @return shareInstance
 */
+(instancetype)shareInstance
{
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        shareService = [[QGThirdPlatformService alloc]init];
    });
    return shareService;
}


/// 打开微信APP
- (BOOL)openWXApp
{
    return [[ZHWeChatTool share] openWXApp];
}

/**
 *  分享方法
 *
 *  @param type        分享到那个平台
 *  @param dic         分享的字典 dic allkeys (imgUrl,image,title,desc,link)
 *  @param resultBlock 分享回调
 */
-(void)shareWithType:(QGShareItemType)type dictionary:(NSDictionary *)dic resultBlock:(void(^)(BOOL isSuccess))resultBlock
{
    //微信好友 微信朋友圈
    if (type == QGShareItemTypeWeChat || type == QGShareItemTypeTimeLine) {
        
        if (![[ZHWeChatTool share] isWXInstalled]) {
            [QGHUDManager showHud:@"尚未安装微信"];
            return;
        }
        
        
        int scene = WXSceneSession;
        if (type == QGShareItemTypeTimeLine) {
            scene = WXSceneTimeline;
        }
        [[ZHWeChatTool share] WXShareWithDic:dic scene:scene];
        //微信分享回调
        [ZHWeChatTool share].wxShareResultBlock = ^(BOOL isSuccess)
        {
            if (resultBlock) {
                resultBlock(isSuccess);
            }
        };
    }
    //QQ空间   //QQ客户端
    else if (type == QGShareItemTypeQQ || type == QGShareItemTypeQQZone)
    {
        if (![[QGTencentTool share] isQQInstalled]) {
            [QGHUDManager showHud:@"尚未安装QQ"];
            return;
        }
        
        QGTencentToolType tencentToolType = QGTencentToolTypeQQ;
        if (type == QGShareItemTypeQQZone) {
            tencentToolType = QGTencentToolTypeQQZone;
        }
        [[QGTencentTool share] QQShareWithDic:dic shareType:tencentToolType];
        [QGTencentTool share].qqShareResultBlock = ^(BOOL isSuccess){
            if (resultBlock) {
                resultBlock(isSuccess);
            }
        };
    }

 

}

/**
*  分享图片方法
*  @param type        分享到那个平台
*  @param dic         分享的字典 dic allkeys (imgUrl,image,title,desc,link)
*  @param resultBlock 分享回调
*/
- (void)shareImageWithType:(QGShareItemType)type dictionary:(NSDictionary *)dic resultBlock:(void(^)(BOOL isSuccess))resultBlock
{
    //微信好友 微信朋友圈
    if (type == QGShareItemTypeWeChat || type == QGShareItemTypeTimeLine) {
        
        if (![[ZHWeChatTool share] isWXInstalled]) {
            [QGHUDManager showHud:@"尚未安装微信"];
            return;
        }
        
        int scene = WXSceneSession;
        if (type == QGShareItemTypeTimeLine) {
            scene = WXSceneTimeline;
        }
        [[ZHWeChatTool share] WXShareImageObjectWithDic:dic scene:scene];
        //微信分享回调
        [ZHWeChatTool share].wxShareResultBlock = ^(BOOL isSuccess)
        {
            if (resultBlock) {
                resultBlock(isSuccess);
            }
        };
    }
    //QQ空间   //QQ客户端
    else if (type == QGShareItemTypeQQ || type == QGShareItemTypeQQZone)
    {
        if (![[QGTencentTool share] isQQInstalled]) {
            [QGHUDManager showHud:@"尚未安装QQ"];
            return;
        }
        
        QGTencentToolType tencentToolType = QGTencentToolTypeQQ;
        if (type == QGShareItemTypeQQZone) {
            tencentToolType = QGTencentToolTypeQQZone;
        }
        [[QGTencentTool share] QQShareImageWithDic:dic shareType:tencentToolType];
        [QGTencentTool share].qqShareResultBlock = ^(BOOL isSuccess){
            if (resultBlock) {
                resultBlock(isSuccess);
            }
        };
    }
}

/**
 *  分享文本信息
 *
 *  @param type        分享到那个平台
 *  @param text        分享的文本
 *  @param resultBlock 分享回调
 */
- (void)shareTextWithType:(QGShareItemType)type text:(NSString *)text resultBlock:(void(^)(BOOL isSuccess))resultBlock
{
    //暂只支持微信好友
    if (type == QGShareItemTypeWeChat) {
        ZHWeChatTool * weChatTool = [ZHWeChatTool share];
        [weChatTool shareTextToWXWithText:text scene:WXSceneSession];
        
        //微信分享回调
        [ZHWeChatTool share].wxShareResultBlock = ^(BOOL isSuccess)
        {
            if (resultBlock) {
                resultBlock(isSuccess);
            }
        };
    }
    //QQ空间   //QQ客户端
    else if (type == QGShareItemTypeQQ || type == QGShareItemTypeQQZone)
    {
        QGTencentToolType tencentToolType = QGTencentToolTypeQQ;
        if (type == QGShareItemTypeQQZone) {
            tencentToolType = QGTencentToolTypeQQZone;
        }
        [[QGTencentTool share] shareTextToQQWithText:text shareType:tencentToolType];
        [QGTencentTool share].qqShareResultBlock = ^(BOOL isSuccess){
            if (resultBlock) {
                resultBlock(isSuccess);
            }
        };
    }

}


/**
 *  微信支付
 *
 *  @param payInfoDic   微信支付需要的必穿参数
 *  @param successBlock 支付回调
 */
- (void)wxPayWithPayinfoDic:(NSDictionary *)payInfoDic result:(void(^)(BOOL isSuccess))successBlock
{
    [[ZHWeChatTool share]WXPayWithPayinfoDic:payInfoDic result:successBlock];
}



/// 微信登录
/// @param successBlock 成功回调
- (void)wxAuthWithSuccess:(void(^)(QGWechatLoginInfoModel * infoModel))successBlock
{
    [[ZHWeChatTool share] WXLogin];
    [ZHWeChatTool share].authSuccessBlock = ^(QGWechatLoginInfoModel *infoModel) {
        if (successBlock) {
            successBlock(infoModel);
        }
    };
    
}


/**
 *  第三方平台回调
 *
 *  @param url      回调URL
 *  @param delegate 代理设置
 *
 *  @return 成功 YES 否则 NO
 */
-(BOOL)handleOpenURL:(NSURL *) url delegate:(id) delegate
{
    NSString * scheme = url.scheme;
    if ([scheme isContainOfString:WXAppId]) {
        return [[ZHWeChatTool share] handleOpenURL:url];
    }else if ([scheme isContainOfString:kTencentSchemeKey]) {
        return [[QGTencentTool share] handleOpenURL:url];
    }
    else if ([scheme isContainOfString:@"www.xyqb.com"])
    {
        [[NSNotificationCenter  defaultCenter] postNotificationName:@"payReturn" object:nil];
        return YES;
    }

    return NO;
}

@end
