//
//  QGPushService.m
//  CreditWallet
//
//  Created by 张博 on 17/1/22.
//  Copyright © 2017年 QuantGroup. All rights reserved.
//

#import "QGPushService.h"
#import "MiPushSDK.h"
#import "QGUserInfo.h"
#import <UIKit/UIKit.h>

#import "QGApplicationOpenURL.h"
#import "SensorsAnalyticsSDK.h"

#import "JPUSHService.h"
#import "JPushNotificationExtensionService.h"

#import "QGAppMacro.h"

#import <AdSupport/AdSupport.h>

@interface QGPushService ()<MiPushSDKDelegate,UNUserNotificationCenterDelegate,JPUSHRegisterDelegate>

///每次启动记录推送需要的字典
@property (nonatomic, strong) NSDictionary * launchOptions;

/**
 上一次推送的ID，用于过滤一次同一个ID的消息被处理两次的情况
 */
@property (nonatomic, strong) NSString *lastPushMessageId;

@end



@implementation QGPushService

+ (instancetype)sharedQGPushService
{
    static QGPushService * shareService;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        shareService = [[self alloc] init];
    });
    return shareService;
}

///加载推送基础信息
+(void)loadQGPushConfig:(NSDictionary *)launchOptions
{
    [self registerQGPush];
    /// JPush -------------------------
    [self registerJPushType];
    
    BOOL apsEnv = [[NSString stringWithFormat:@"%@",kApsForProduction] boolValue];
    NSString *uuid = [[[ASIdentifierManager sharedManager] advertisingIdentifier] UUIDString];
    /// 原JPush Appkey 被删 ??
    [JPUSHService setupWithOption:launchOptions appKey:kJPushAppKey
                                channel:@"AppStore"
                       apsForProduction:apsEnv
                  advertisingIdentifier:uuid];
    [JPushNotificationExtensionService jpushSetAppkey:kJPushAppKey];
    /// JPush -------------------------
    //设置推送Account
    if ([QGUserInfo isLogin]) {
        [self setPushAccount:[QGUserInfo sharedUserInfo].userId];
    }
    else
    {
        [self unsetPushAccount:nil];
    }
    
    [QGPushService sharedQGPushService].launchOptions = launchOptions;
    
//    // 点击通知打开app处理逻辑
//    NSDictionary* userInfo = [launchOptions objectForKey:UIApplicationLaunchOptionsRemoteNotificationKey];
//    if (userInfo) {
//        [[QGPushService sharedQGPushService] didReceiveRemoteNotification:userInfo];
//    }
}


/// 极光推送注册
+ (void)registerJPushType
{
    JPUSHRegisterEntity * entity = [[JPUSHRegisterEntity alloc] init];
    entity.types = JPAuthorizationOptionAlert|JPAuthorizationOptionBadge|JPAuthorizationOptionSound|JPAuthorizationOptionProvidesAppNotificationSettings;
    if ([[UIDevice currentDevice].systemVersion floatValue] >= 8.0) {
      // 可以添加自定义 categories
      // NSSet<UNNotificationCategory *> *categories for iOS10 or later
      // NSSet<UIUserNotificationCategory *> *categories for iOS8 and iOS9
    }
    [JPUSHService registerForRemoteNotificationConfig:entity delegate:[self sharedQGPushService]];
}

///注册推送
+(void)registerQGPush
{
    [MiPushSDK registerMiPush:[self sharedQGPushService] type:0 connect:YES];

}

///绑定deviceToken
+(void)bindDeviceToken:(NSData *)deviceToken
{
    [MiPushSDK bindDeviceToken:deviceToken];
    /// 极光推送
    [JPUSHService registerDeviceToken:deviceToken];
}

//处理收到的 APNs 消息
+ (void)handleRemoteNotification:(NSDictionary *)remoteInfo
{
    if ([remoteInfo valueForKey:@"_j_msgId"]) {
         [JPUSHService handleRemoteNotification:remoteInfo];
    }else{
         [MiPushSDK handleReceiveRemoteNotification:remoteInfo];
    }
    [[self sharedQGPushService] didReceiveRemoteNotification:remoteInfo];
}

///设置推送账号
+ (void)setPushAccount:(NSString *)account
{
    QGUserInfo *userInfo = [QGUserInfo sharedUserInfo];
    if (userInfo.userName) {
        [MiPushSDK setAccount:userInfo.userName];
    }
    [MiPushSDK setAlias:account];
    [MiPushSDK subscribe:@"login"];
    [MiPushSDK unsubscribe:@"logout"];
   
    /// 极光推送---------------------------
    [JPUSHService setAlias:account completion:^(NSInteger iResCode, NSString *iAlias, NSInteger seq) {
        NSLog(@"设置别名:%@",iAlias);
    } seq:2];
    [JPUSHService setTags:[NSSet setWithObject:@"login"] completion:^(NSInteger iResCode, NSSet *iTags, NSInteger seq) {
        
    } seq:1];
    /// 极光推送---------------------------
}

///取消推送账号
+ (void)unsetPushAccount:(NSString *)account
{
    if (QGUserInfo.sharedUserInfo.userName.length > 0) {
        [MiPushSDK unsetAccount:QGUserInfo.sharedUserInfo.userName];
    }
    [MiPushSDK unsetAlias:account];
    [MiPushSDK subscribe:@"logout"];
    [MiPushSDK unsubscribe:@"login"];
    
    /// 极光推送---------------------------
    [JPUSHService deleteAlias:^(NSInteger iResCode, NSString *iAlias, NSInteger seq) {
        NSLog(@"删除别名 = %@",iAlias);
    } seq:1];
    [JPUSHService setTags:[NSSet setWithObject:@"logout"] completion:^(NSInteger iResCode, NSSet *iTags, NSInteger seq) {
        
    } seq:1];
    /// 极光推送---------------------------
}

-(void)didReceiveRemoteNotification:(NSDictionary *)userInfo
{
    //如果本次要处理的推送消息的ID与之前的消息ID一致，那就不处理了。
    if ([self.lastPushMessageId isEqualToString:[userInfo objectForKey:@"_id_"]]) {
        return;
    }

    UIApplicationState state = [UIApplication sharedApplication].applicationState;
    if (state == UIApplicationStateInactive || state == UIApplicationStateActive)
    {
        NSString * navUrl = userInfo[@"navUrl"];
        if (navUrl.length > 0) {
            dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(.5 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
                [QGApplicationOpenURL handleAllSupportUrl:navUrl];
            });
        }
    }
    else
    {
        
    }
 
    //处理点击通知打开app的逻辑
    NSString *messageId = [userInfo objectForKey:@"_id_"];
    if (messageId != nil) {
        [MiPushSDK openAppNotify:messageId];
    }
    
    
    
    self.lastPushMessageId = messageId;
}

//发送本地通知，用于清空应用图标角标，但不影响消息通知栏中的消息
+ (void)clearApplicationIconBadgeNumber {
    [UIApplication sharedApplication].applicationIconBadgeNumber = 0;
    
    [[UIApplication sharedApplication] cancelAllLocalNotifications];
    
    //下面这段代码会引发一种bug
    //程序杀掉时会重新执行入口函数
    /*
    //定义本地通知对象
    UILocalNotification *notification = [[UILocalNotification alloc] init];
    //设置通知属性，应用程序图标右上角显示的消息数
    notification.applicationIconBadgeNumber = -1;
    //调用通知
    [[UIApplication sharedApplication] presentLocalNotificationNow:notification];
     */
    [JPUSHService resetBadge];
}

#pragma mark MiPushSDKDelegate
- (void)miPushRequestSuccWithSelector:(NSString *)selector data:(NSDictionary *)data
{
//    NSLog(@"selector = %@ \n\n data = %@",selector,data);
    // 在此获取regId
    if ([selector isEqualToString:@"bindDeviceToken:"]) {
        NSLog(@"regid = %@", data[@"regid"]);
        NSString * regid = data[@"regid"];
       // 将小米推送的regId 存储在神策分析的用户 Profile "xmId" 中
       [[[SensorsAnalyticsSDK sharedInstance] people] set:@{@"xmId" : regid}];
    }
}

- (void)miPushRequestErrWithSelector:(NSString *)selector error:(int)error data:(NSDictionary *)data
{
    
}

- (void)miPushReceiveNotification:(NSDictionary*)data
{

}


#pragma mark - JPUSHRegisterDelegate

- (void)jpushNotificationCenter:(UNUserNotificationCenter *)center didReceiveNotificationResponse:(UNNotificationResponse *)response withCompletionHandler:(void(^)(void))completionHandler API_AVAILABLE(ios(10.0)){
    NSDictionary * userInfo = response.notification.request.content.userInfo;
    [JPushNotificationExtensionService jpushReceiveNotificationRequest:response.notification.request with:^{
        NSLog(@"---------------------------------------JPush Report Success");
    }];
    if([response.notification.request.trigger isKindOfClass:[UNPushNotificationTrigger class]]) {
      [QGPushService handleRemoteNotification:userInfo];
    }
    completionHandler();
}

- (void)jpushNotificationAuthorization:(JPAuthorizationStatus)status withInfo:(NSDictionary *)info {
    
}

/// 屏蔽当APP打开时依然能收到显示推送的行为


// iOS 10 Support
- (void)jpushNotificationCenter:(UNUserNotificationCenter *)center willPresentNotification:(UNNotification *)notification withCompletionHandler:(void (^)(NSInteger))completionHandler  API_AVAILABLE(ios(10.0)){
  // Required
  NSDictionary * userInfo = notification.request.content.userInfo;
  if([notification.request.trigger isKindOfClass:[UNPushNotificationTrigger class]]) {
    [JPUSHService handleRemoteNotification:userInfo];
  }
  completionHandler(UNNotificationPresentationOptionAlert);
}




@end
