//
//  QGWindowManager.m
//  CreditWallet
//
//  Created by 张博 on 2017/7/10.
//  Copyright © 2017年 QuantGroup. All rights reserved.
//

#import "QGWindowManager.h"
#import "QGGuideViewController.h"
#import "QGPrivacyProtocolController.h"

#import "QGAppMacro.h"

#define IsAgreePrivacyProtocol @"IsAgreePrivacyProtocol"

@implementation QGWindowManager

+ (instancetype)shareInstance
{
    static dispatch_once_t onceToken;
    static QGWindowManager * shareManager = nil;
    dispatch_once(&onceToken, ^{
        shareManager = [[QGWindowManager alloc]init];
    });
    return shareManager;
}

/**
 检查是否应该显示前面功能window，如果需要则直接展示
 */
+ (void)checkIsNeedShowFrontWindow
{
    //是否同意过协议
    BOOL isAgreePrivacy = [[NSUserDefaults standardUserDefaults] boolForKey:IsAgreePrivacyProtocol];
    if (!isAgreePrivacy) {
        [[QGWindowManager shareInstance] showPrivacyProtocol];
    }
    
    //引导图是否浏览过
    BOOL result = [[NSUserDefaults standardUserDefaults] boolForKey:GuideKeyVersion];
    if (!result) {
        [[QGWindowManager shareInstance] showLaunchGuide];
    }
    
    //闪屏图缓存是否已清理
    BOOL launchResult = [[NSUserDefaults standardUserDefaults] boolForKey:LaunchScreenVersion];
    if (!launchResult) {
        //清理闪屏缓存
        [self clearLaunchScreenCache];
    }
    
}


/// 清理闪屏图片
+ (void)clearLaunchScreenCache {
    NSError *error;
    [NSFileManager.defaultManager removeItemAtPath:[NSString stringWithFormat:@"%@/Library/SplashBoard",NSHomeDirectory()] error:&error];
    if (error) {
        NSLog(@"Failed to delete launch screen cache: %@",error);
    }
    
    [[NSUserDefaults standardUserDefaults] setBool:YES forKey:LaunchScreenVersion];
    [[NSUserDefaults standardUserDefaults] synchronize];
}



/**
 欢迎页显示
 */
-(void)showLaunchGuide
{    
    UIViewController *guideViewController = [[QGGuideViewController alloc] init];
    UIWindow *guideWindow = [[UIWindow alloc] initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT)];
    guideWindow.windowLevel = UIWindowLevelNormal + 1;
    guideWindow.alpha = 1;
    guideWindow.hidden = NO;
    self.guideWindow = guideWindow;
    guideWindow.rootViewController = guideViewController;
    guideWindow.backgroundColor = [UIColor yellowColor];
    
}

- (void)dismissGuideWindowAnimated:(BOOL)animated {
    
    [[NSUserDefaults standardUserDefaults] setBool:YES forKey:GuideKeyVersion];
    [[NSUserDefaults standardUserDefaults] synchronize];
    
    NSTimeInterval animationDuration = 0;
    if (animated) {
        animationDuration = 1.0;
    }
    [UIView animateWithDuration:animationDuration delay:0 options:UIViewAnimationOptionCurveEaseOut animations:^{
        self.guideWindow.alpha = 0.0;
    } completion:^(BOOL finished) {
        self.guideWindow.windowLevel = UIWindowLevelNormal - 1;
        self.guideWindow = nil;
    }];
}





/// 显示隐私协议
- (void)showPrivacyProtocol
{
    UIViewController * privacyProtocolController = [[QGPrivacyProtocolController alloc] init];
    UIWindow * privacyProtocolWindow = [[UIWindow alloc] initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT)];
    privacyProtocolWindow.windowLevel = UIWindowLevelNormal + 2;
    privacyProtocolWindow.alpha = 1;
    privacyProtocolWindow.hidden = NO;
    self.privacyProtocolWindow = privacyProtocolWindow;
    privacyProtocolWindow.rootViewController = privacyProtocolController;
    
}

/// 隐藏隐私协议
- (void)dismissPrivacyProtocolWindowAnimated:(BOOL)animated
{
    [[NSUserDefaults standardUserDefaults] setBool:YES forKey:IsAgreePrivacyProtocol];
    [[NSUserDefaults standardUserDefaults] synchronize];
    
    NSTimeInterval animationDuration = 0;
    if (animated) {
        animationDuration = 1.0;
    }
    [UIView animateWithDuration:animationDuration delay:0 options:UIViewAnimationOptionCurveEaseOut animations:^{
        self.privacyProtocolWindow.alpha = 0.0;
    } completion:^(BOOL finished) {
        self.privacyProtocolWindow.windowLevel = UIWindowLevelNormal - 1;
        self.privacyProtocolWindow = nil;
    }];
}




@end
