//
//  QGMianNetwork.m
//  VirtualPayment
//
//  Created by 张博 on 2019/5/21.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGMainNetwork.h"
#import "QGAppMacro.h"
#import "QGGlobalConst.h"
#import "QGUserInfo.h"
#import "QGToolsConfig.h"
#import <AdSupport/AdSupport.h>
@implementation QGMainNetwork

+ (instancetype)shareManager {
    static QGMainNetwork *manager = nil;
    static dispatch_once_t pred;
    dispatch_once(&pred, ^{
        manager = [[self alloc] init];
    });
    return manager;
}


#pragma mark - Login & Logout
///刷新Token
- (void)refreshToken
{
    //刷新token时需要重置请求构造器
    [self resetRequestSerializer];
    [self configHTTPHeaders];
}

- (instancetype)init
{
    if (self = [super init]) {
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(refreshToken) name:ModelCenterUserLoginNotification object:nil];
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(refreshToken) name:ModelCenterUserLogOutNotification object:nil];
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(refreshToken) name:ModelCenterUserRefreshToken object:nil];
    }
    return self;
}

///配置通用header
- (void)configHTTPHeaders
{
    NSString *version = XcodeAppVersion;
    [self setRequestHTTPHeaderValue:version forkey:@"version"];
    [self setRequestHTTPHeaderValue:appChannel forkey:@"appchannel"];
    NSString *idfaStr = [[[ASIdentifierManager sharedManager] advertisingIdentifier] UUIDString];
    [self setRequestHTTPHeaderValue:idfaStr forkey:@"idfa"];
    [self setRequestHTTPHeaderValue:idfaStr forkey:@"device_id"];
    [self setRequestHTTPHeaderValue:registerFrom forkey:@"channel"];
    //商城后台用于区分是否是主包APP，Android iOS都为0 量卡为2
    [self setRequestHTTPHeaderValue:@"0" forkey:@"source"];
    [self setRequestHTTPHeaderValue:@"zhenxianghua" forkey:@"appName"];
    [self configToken];
}


///配置token
- (void)configToken
{
//    NSString *token = [QGUserInfo sharedUserInfo].apiToken;
    NSString * token;
    NSString *Authorization = [NSString stringWithFormat:@"%@%@", @"Bearer ", token];
    if (token) {
        [self setRequestHTTPHeaderValue:Authorization forkey:@"Authorization"];
    }
}



- (NSString *)baseUrlString
{
    return [NSString stringWithFormat:@"%@/",AppBackendBaseUrl];
}

- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self name:ModelCenterUserLoginNotification object:nil];
    [[NSNotificationCenter defaultCenter] removeObserver:self name:ModelCenterUserLogOutNotification object:nil];
    [[NSNotificationCenter defaultCenter] removeObserver:self name:ModelCenterUserRefreshToken object:nil];
}

@end
