//
//  QGBatchRequestOperation.h
//  VirtualPayment
//
//  Created by 张博 on 2019/5/23.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "AsynchronousOperation.h"
#import "QGBaseNetwork.h"
NS_ASSUME_NONNULL_BEGIN

@class QGBatchOperationManager;


@interface QGBatchRequestOperation : AsynchronousOperation



/**
 依赖关系网络请求 GET

 @param urlString 拼接的URL
 @param networkClassName 继承于BaseNetWork的类名
 @param parameters body参数
 @param success 成功回调
 @param failure 失败回调
 @return 实例化对象
 */
+ (instancetype)GET:(NSString *)urlString networkClassName:(NSString *)networkClassName parameters:(NSDictionary *)parameters success:(BaseRequestSuccessBlock)success failure:(BaseRequestFailureBlock)failure;

/**
 依赖关系网络请求 POST
 
 @param urlString 拼接的URL
 @param networkClassName 继承于BaseNetWork的类名
 @param parameters body参数
 @param success 成功回调
 @param failure 失败回调
 @return 实例化对象
 */
+ (instancetype)POST:(NSString *)urlString networkClassName:(NSString *)networkClassName parameters:(NSDictionary *)parameters success:(BaseRequestSuccessBlock)success failure:(BaseRequestFailureBlock)failure;

@end

NS_ASSUME_NONNULL_END
