//
//  QGAuthNetwork.m
//  VirtualPayment
//
//  Created by 张博 on 2019/7/3.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGAuthNetwork.h"
#import "QGAppMacro.h"
#import "QGGlobalConst.h"
#import "QGUserInfo.h"
#import "QGToolsConfig.h"
#import <AdSupport/AdSupport.h>
@implementation QGAuthNetwork

+ (instancetype)shareManager {
    static QGAuthNetwork *manager = nil;
    static dispatch_once_t pred;
    dispatch_once(&pred, ^{
        manager = [[self alloc] init];
    });
    return manager;
}


- (instancetype)init
{
    if (self = [super init]) {
        [self addHTTPHeaders];
    }
    return self;
}

- (void)addHTTPHeaders
{
    NSString *version = XcodeAppVersion;
    [self setRequestHTTPHeaderValue:version forkey:@"version"];
    [self setRequestHTTPHeaderValue:appChannel forkey:@"appchannel"];
    NSString *idfaStr = [[[ASIdentifierManager sharedManager] advertisingIdentifier] UUIDString];
    [self setRequestHTTPHeaderValue:idfaStr forkey:@"idfa"];
    [self setRequestHTTPHeaderValue:idfaStr forkey:@"device_id"];
    [self setRequestHTTPHeaderValue:registerFrom forkey:@"channel"];
    [self setRequestHTTPHeaderValue:@"zhenxianghua" forkey:@"appName"];
    //任峰那边的接口必须是http
    self.requestSerializerType = QGRequestSerializerTypeHTTP;
}





- (NSString *)baseUrlString
{
    return [NSString stringWithFormat:@"%@/",AuthBaseUrl];
}

@end
