//
//  QGNetWork.m
//  QGNetWork
//
//  Created by 银恭敬 on 1/15/16.
//  Copyright © 2016 cbs. All rights reserved.
//

#import "QGNetWork.h"
#import "QGUserInfo.h"
#import "QGToolsConfig.h"
#import "QGAppMacro.h"
#import <AdSupport/AdSupport.h>


@interface QGNetWork ()

@property (nonatomic, strong) AFHTTPSessionManager *AFHTTPSessionManager;
@property (nonatomic, copy) NSString *ipAddress;
@property (nonatomic, assign) NSInteger reTryCount;

@end

@implementation QGNetWork
+ (instancetype)sharedManager {
    static QGNetWork *manager = nil;
    static dispatch_once_t pred;
    dispatch_once(&pred, ^{
        manager = [[self alloc] initWithBaseURL:nil];
    });
    return manager;
}

- (instancetype)initWithBaseURL:(NSURL *)url {
    self = [super initWithBaseURL:url];
    if (self) {
        // 请求超时设定
        self.requestSerializer.cachePolicy = NSURLRequestReloadIgnoringLocalCacheData;
        self.securityPolicy.allowInvalidCertificates = YES;
        _AFHTTPSessionManager = [AFHTTPSessionManager manager];
        _reTryCount = 1;
        _ipAddress = @"";
        //zhangbo 修改
        _AFHTTPSessionManager.responseSerializer.acceptableContentTypes = [NSSet setWithObjects:@"application/json", @"text/html", nil];
        _AFHTTPSessionManager.responseSerializer = [AFJSONResponseSerializer serializer];
        [[AFNetworkReachabilityManager sharedManager] startMonitoring];
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(reachabilityDidChangeNotification:) name:AFNetworkingReachabilityDidChangeNotification object:nil];
    }
    return self;
}

///更新请求头参数
- (void)updateHeaderTimeoutInterval:(NSTimeInterval)timeoutInterval {
//    NSString *token = [QGUserInfo sharedUserInfo].apiToken;
    NSString *token;

    NSString *Authorization = [NSString stringWithFormat:@"%@%@", @"Bearer ", token];
    if (token) {
        [_AFHTTPSessionManager.requestSerializer setValue:Authorization forHTTPHeaderField:@"Authorization"];
    } else {
        [_AFHTTPSessionManager.requestSerializer setValue:@"" forHTTPHeaderField:@"Authorization"];
    }
    NSString *version = XcodeAppVersion;
    [_AFHTTPSessionManager.requestSerializer setValue:version forHTTPHeaderField:@"version"];

    [_AFHTTPSessionManager.requestSerializer setValue:appChannel forHTTPHeaderField:@"appchannel"];
    NSString *idfaStr = [[[ASIdentifierManager sharedManager] advertisingIdentifier] UUIDString];
    [_AFHTTPSessionManager.requestSerializer setValue:idfaStr forHTTPHeaderField:@"idfa"];
    [_AFHTTPSessionManager.requestSerializer setValue:idfaStr forHTTPHeaderField:@"device_id"];
    [_AFHTTPSessionManager.requestSerializer setValue:registerFrom forHTTPHeaderField:@"channel"];
    //商城后台用于区分是否是主包APP，Android iOS都为0 量卡为2
    [_AFHTTPSessionManager.requestSerializer setValue:@"0" forHTTPHeaderField:@"source"];
    [_AFHTTPSessionManager.requestSerializer setValue:@"zhenxianghua" forHTTPHeaderField:@"appName"];
    [_AFHTTPSessionManager.requestSerializer setValue:@"gzip" forHTTPHeaderField:@"Accept-Encoding"];
    //    设置请求的编码类型
    [_AFHTTPSessionManager.requestSerializer setValue:@"gzip" forHTTPHeaderField:@"Content-Encoding"];

    if (timeoutInterval <= 0) {
        _AFHTTPSessionManager.requestSerializer.timeoutInterval = 30;
    } else {
        _AFHTTPSessionManager.requestSerializer.timeoutInterval = timeoutInterval;
    }
}

///设置参数上传方式是二进制
- (void)setHttpRequestSerializerTimeoutInterval:(NSTimeInterval)timeoutInterval {
    _AFHTTPSessionManager.requestSerializer = [AFHTTPRequestSerializer serializer];
    [self updateHeaderTimeoutInterval:timeoutInterval];
}
///设置参数上传方式是json 不会影响参数类型
- (void)setJsonRequestSerializertTimeoutInterval:(NSTimeInterval)timeoutInterval {
    _AFHTTPSessionManager.requestSerializer = [AFJSONRequestSerializer serializer];
    [self updateHeaderTimeoutInterval:timeoutInterval];
}

- (void)GET:(NSString *)URLString parameters:(NSDictionary *)parameters success:(requestSuccessBlock)success failure:(requestFailureBlock)failure {
    [self GET:URLString timeoutInterval:0 parameters:parameters success:success failure:failure];
}

- (void)GET:(NSString *)URLString requestSerializer:(QGNetWorkRequestSerializer)requestSerializer parameters:(NSDictionary *)parameters businessSuccess:(businessCodeRequestSuccessBlock)businessSuccess failure:(requestFailureBlock)failure {
    [self privateSendRequestWithUrlString:URLString requestSerializer:requestSerializer timeoutInterval:0 opt:OPT_GET parameters:parameters businessSuccess:businessSuccess success:nil failure:failure];
}

- (void)GET:(NSString *)URLString timeoutInterval:(NSTimeInterval)timeoutInterval parameters:(NSDictionary *)parameters success:(requestSuccessBlock)success failure:(requestFailureBlock)failure {
    [self sendRequestWithUrlString:URLString timeoutInterval:timeoutInterval opt:OPT_GET parameters:parameters success:success failure:failure];
}

- (void)POST:(NSString *)URLString parameters:(NSDictionary *)parameters success:(requestSuccessBlock)success failure:(requestFailureBlock)failure {
    [self sendRequestWithUrlString:URLString opt:OPT_POST parameters:parameters success:success failure:failure];
}

- (void)POST:(NSString *)URLString requestSerializer:(QGNetWorkRequestSerializer)requestSerializer parameters:(NSDictionary *)parameters businessSuccess:(businessCodeRequestSuccessBlock)businessSuccess failure:(requestFailureBlock)failure {
    [self privateSendRequestWithUrlString:URLString requestSerializer:requestSerializer timeoutInterval:0 opt:OPT_POST parameters:parameters businessSuccess:businessSuccess success:nil failure:failure];
}

- (void)PUT:(NSString *)URLString parameters:(NSDictionary *)parameters success:(requestSuccessBlock)success failure:(requestFailureBlock)failure {
    [self sendRequestWithUrlString:URLString opt:OPT_PUT parameters:parameters success:success failure:failure];
}

- (void)sendRequestWithUrlString:(NSString *)urlString timeoutInterval:(NSTimeInterval)timeoutInterval opt:(NSString *)opt parameters:(NSDictionary *)parameters success:(requestSuccessBlock)success failure:(requestFailureBlock)failure {
    [self privateSendRequestWithUrlString:urlString requestSerializer:QGNetWorkRequestSerializerNone timeoutInterval:timeoutInterval opt:opt parameters:parameters businessSuccess:nil success:success failure:failure];
}

#pragma mark - Private
///是否包含数组，如果包含就选用json方式上传，防止出错
- (BOOL)isContainArrayWithDic:(NSDictionary *)parameters {
    BOOL result = NO;
    for (id obj in parameters.allValues) {
        if ([obj isKindOfClass:[NSArray class]]) {
            result = YES;
            break;
        } else if ([obj isKindOfClass:[NSDictionary class]]) {
            NSDictionary *subDic = (NSDictionary *) obj;
            if ([self isContainArrayWithDic:subDic]) {
                result = YES;
            }
        }
    }
    return result;
}

- (void)privateSendRequestWithUrlString:(NSString *)urlString requestSerializer:(QGNetWorkRequestSerializer)requestSerializer timeoutInterval:(NSTimeInterval)timeoutInterval opt:(NSString *)opt parameters:(NSDictionary *)parameters businessSuccess:(businessCodeRequestSuccessBlock)businessSuccess success:(requestSuccessBlock)success failure:(requestFailureBlock)failure {
    BOOL networkStatus = [self checkNetworkStatus];
    if (!networkStatus) {
        NSDictionary *failureDic = [NSDictionary dictionaryWithObject:@"当前网络不可用" forKey:@"message"];
        if (failure) {
            failure(failureDic);
        }
        return;
    }
    //没有指定类型的，主要为了兼容旧接口
    if (requestSerializer == QGNetWorkRequestSerializerNone) {
        BOOL isContainArray = [self isContainArrayWithDic:parameters];
        if (isContainArray) {
            //参数类型不会发生变化
            [self setJsonRequestSerializertTimeoutInterval:timeoutInterval];
        } else {
            [self setHttpRequestSerializerTimeoutInterval:timeoutInterval];
        }
    }
    //http编码
    else if (requestSerializer == QGNetWorkRequestSerializerHttp) {
        [self setHttpRequestSerializerTimeoutInterval:timeoutInterval];
    }
    //json编码
    else if (requestSerializer == QGNetWorkRequestSerializerJson) {
        //参数类型不会发生变化
        [self setJsonRequestSerializertTimeoutInterval:timeoutInterval];
    }
    
        NSLog(@"🙏🙏🙏\n---sendStart----\n【%@】sendrequest:%@ parameters:%@\n----sendEnd-----\n\n", opt, urlString, parameters);

        //GET
        if ([opt isEqualToString:OPT_GET]) {
            [self.AFHTTPSessionManager GET:urlString
                parameters:parameters
                progress:nil
                success:^(NSURLSessionTask *task, NSDictionary *responseObject) {
                    [self logSuccessWithRequestWithUrlString:urlString opt:opt parameters:parameters responseObject:responseObject];
                    [self requestSuccessWithResponseObject:responseObject businessSuccess:businessSuccess success:success];
                }
                failure:^(NSURLSessionTask *operation, NSError *error) {
                    [self requestFailureWithError:error urlString:urlString opt:opt parameters:parameters failure:failure];
                }];
        }
        //PUT
        else if ([opt isEqualToString:OPT_PUT]) {
            [self.AFHTTPSessionManager PUT:urlString
                parameters:parameters
                success:^(NSURLSessionDataTask *_Nonnull task, id _Nonnull responseObject) {
                    [self logSuccessWithRequestWithUrlString:urlString opt:opt parameters:parameters responseObject:responseObject];
                    [self requestSuccessWithResponseObject:responseObject businessSuccess:businessSuccess success:success];
                }
                failure:^(NSURLSessionDataTask *_Nonnull task, NSError *_Nonnull error) {
                    [self requestFailureWithError:error urlString:urlString opt:opt parameters:parameters failure:failure];
                }];
        }
        //POST
        else if ([opt isEqualToString:OPT_POST]) {
            [self.AFHTTPSessionManager POST:urlString
                parameters:parameters
                progress:nil
                success:^(NSURLSessionTask *task, NSDictionary *responseObject) {
                    [self logSuccessWithRequestWithUrlString:urlString opt:opt parameters:parameters responseObject:responseObject];
                    [self requestSuccessWithResponseObject:responseObject businessSuccess:businessSuccess success:success];
                }
                failure:^(NSURLSessionTask *operation, NSError *error) {
                    [self requestFailureWithError:error urlString:urlString opt:opt parameters:parameters failure:failure];
                }];
        } else {
            NSLog(@"请求类型错误，请检查请求库");
        }
    
    
}

///所有的请求成功的回调
- (void)requestSuccessWithResponseObject:(NSDictionary *)responseObject businessSuccess:(businessCodeRequestSuccessBlock)businessSuccess success:(requestSuccessBlock)success {
    if (success) {
        success(responseObject);
    }

    if (businessSuccess) {
        NSString *businessCode = [NSString stringWithFormat:@"%@", responseObject[@"businessCode"]];
        NSString *code = [NSString stringWithFormat:@"%@", responseObject[@"code"]];
        businessSuccess(businessCode, code, responseObject);
    }
}

///所有的请求失败的回调
- (void)requestFailureWithError:(NSError *)error urlString:(NSString *)urlString opt:(NSString *)opt parameters:(NSDictionary *)parameters failure:(requestFailureBlock)failure {
    NSData *errorData = error.userInfo[AFNetworkingOperationFailingURLResponseDataErrorKey];
    if (!errorData) {
        error = nil;
        [self logTimeoutWithRequestWithUrlString:urlString opt:opt parameters:parameters];

    } else {
        error = [NSJSONSerialization JSONObjectWithData:errorData options:kNilOptions error:nil];
        [self logError:error urlString:urlString opt:opt];
    }

    if (failure) {
        failure(error);
    }
}

- (BOOL)checkNetworkStatus {
    AFNetworkReachabilityStatus networkReachabilityStatus = [AFNetworkReachabilityManager sharedManager].networkReachabilityStatus;
    if (networkReachabilityStatus == AFNetworkReachabilityStatusNotReachable) {
        return NO;
    } else if (networkReachabilityStatus == AFNetworkReachabilityStatusReachableViaWWAN) {
        return YES;

    } else if (networkReachabilityStatus == AFNetworkReachabilityStatusReachableViaWiFi) {
        return YES;

    }
    return YES;
}

/**
 Whether or not the network is currently reachable.
 */
- (BOOL)reachable
{
    return [AFNetworkReachabilityManager sharedManager].reachable;
}


// 获取网络连接类型
+ (NSString *)getNetworkType {
    NSString *networksType = @"Unknown";
    AFNetworkReachabilityStatus networkReachabilityStatus = [AFNetworkReachabilityManager sharedManager].networkReachabilityStatus;
    if (networkReachabilityStatus == AFNetworkReachabilityStatusNotReachable) {
        networksType = @"NotReachable";
    } else if (networkReachabilityStatus == AFNetworkReachabilityStatusReachableViaWWAN) {
        //        NSLog(@"*******蜂窝网络");
        networksType = @"WWAN";

    } else if (networkReachabilityStatus == AFNetworkReachabilityStatusReachableViaWiFi) {
        //        NSLog(@"*******WIFI");
        networksType = @"WiFi";
    }
    return networksType;
}

- (void)sendRequestWithUrlString:(NSString *)urlString opt:(NSString *)opt parameters:(NSDictionary *)parameters success:(requestSuccessBlock)success failure:(requestFailureBlock)failure {
    [self sendRequestWithUrlString:urlString timeoutInterval:0 opt:opt parameters:parameters success:success failure:failure];
}

#pragma mark - AFNetworkingReachabilityDidChangeNotification

- (void)reachabilityDidChangeNotification:(NSNotification *)aNotification {
    //增加是否有网验证，修复当没有网络时此处会引发的闪退
    
}


#pragma mark - AFN

- (void)setAuthenticationChallengeBlock {
    __weak __typeof(_AFHTTPSessionManager) weakSessionManager = _AFHTTPSessionManager;
    [_AFHTTPSessionManager setTaskDidReceiveAuthenticationChallengeBlock:^NSURLSessionAuthChallengeDisposition(NSURLSession *_Nonnull session, NSURLSessionTask *_Nonnull task, NSURLAuthenticationChallenge *_Nonnull challenge, NSURLCredential *__autoreleasing _Nullable *_Nullable credential) {
        __strong __typeof(weakSessionManager) strongSessionManager = weakSessionManager;
        NSURLSessionAuthChallengeDisposition disposition = NSURLSessionAuthChallengePerformDefaultHandling;
        NSString *host = challenge.protectionSpace.host;
        if (strongSessionManager.requestSerializer) {
            NSString *headerHost = [[(AFHTTPRequestSerializer *) strongSessionManager.requestSerializer HTTPRequestHeaders] objectForKey:@"host"];
            if (headerHost && headerHost.length > 0) {
                host = headerHost;
            }
        }
        if ([challenge.protectionSpace.authenticationMethod isEqualToString:NSURLAuthenticationMethodServerTrust]) {
            if ([strongSessionManager.securityPolicy evaluateServerTrust:challenge.protectionSpace.serverTrust forDomain:host]) {
                disposition = NSURLSessionAuthChallengeUseCredential;
                *credential = [NSURLCredential credentialForTrust:challenge.protectionSpace.serverTrust];
            } else {
                disposition = NSURLSessionAuthChallengeCancelAuthenticationChallenge;
            }
        } else {
            disposition = NSURLSessionAuthChallengePerformDefaultHandling;
        }
        return disposition;
    }];

    [_AFHTTPSessionManager setSessionDidReceiveAuthenticationChallengeBlock:^NSURLSessionAuthChallengeDisposition(NSURLSession *_Nonnull session, NSURLAuthenticationChallenge *_Nonnull challenge, NSURLCredential *__autoreleasing _Nullable *_Nullable credential) {
        __strong __typeof(weakSessionManager) strongSessionManager = weakSessionManager;
        NSURLSessionAuthChallengeDisposition disposition = NSURLSessionAuthChallengePerformDefaultHandling;
        NSString *host = challenge.protectionSpace.host;
        if (strongSessionManager.requestSerializer) {
            NSString *headerHost = [[(AFHTTPRequestSerializer *) strongSessionManager.requestSerializer HTTPRequestHeaders] objectForKey:@"host"];
            if (headerHost && headerHost.length > 0) {
                host = headerHost;
            }
        }
        if ([challenge.protectionSpace.authenticationMethod isEqualToString:NSURLAuthenticationMethodServerTrust]) {
            if ([strongSessionManager.securityPolicy evaluateServerTrust:challenge.protectionSpace.serverTrust forDomain:host]) {
                *credential = [NSURLCredential credentialForTrust:challenge.protectionSpace.serverTrust];
                if (*credential) {
                    disposition = NSURLSessionAuthChallengeUseCredential;
                } else {
                    disposition = NSURLSessionAuthChallengePerformDefaultHandling;
                }
            } else {
                disposition = NSURLSessionAuthChallengeCancelAuthenticationChallenge;
            }
        } else {
            disposition = NSURLSessionAuthChallengePerformDefaultHandling;
        }
        return disposition;
    }];
}

#pragma mark -Log

- (void)logError:(NSError *)error urlString:(NSString *)urlString opt:(NSString *)opt {
#if DEBUG
    NSLog(@"😢😢😢\n----failStart-----\nrequestUrl = [%@] opt = [%@] Error:{🔥code[%@] 🏃🏻 message[%@]🔥}\n-----failEnd----\n\n", urlString, opt, [error valueForKey:@"code"], [error valueForKey:@"message"]);
#else

#endif
}
- (void)logSuccessWithRequestWithUrlString:(NSString *)urlString opt:(NSString *)opt parameters:(NSDictionary *)parameters responseObject:(NSDictionary *)responseObject {
#if DEBUG
    NSString *requestSuccessStr = [NSString stringWithFormat:@"😁😁😁\n----successStart-----\n【%@】request:%@  \nparameters:%@  \nresponseObject:\n%@\n----successEnd-----\n\n", opt, urlString, parameters, responseObject];
    NSLog(@"%@", requestSuccessStr);
#else

#endif
}

- (void)logTimeoutWithRequestWithUrlString:(NSString *)urlString opt:(NSString *)opt parameters:(NSDictionary *)parameters {
#if DEBUG
    NSString *requestSuccessStr = [NSString stringWithFormat:@"😢😢😢\n----timeoutStart-----\n***** Failure *****【%@】request:%@  \nparameters:%@  \n----timeoutEnd-----\n\n", opt, urlString, parameters];
    NSLog(@"%@", requestSuccessStr);

#else

#endif
}

@end
