//
//  QGLocationManager.h
//  VirtualPayment
//
//  Created by silicn on 2020/4/24.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreLocation/CLPlacemark.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSUInteger,QGLocationStatus)
{
    QGLocationStatusNotAvaiable = 1, /// 不可用
    QGLocationStatusNotDetermined,   /// 尚未决定
    QGLocationStatusAuthed,          /// 已经授权
    QGLocationStatusDenied           /// 拒绝授权
    
};

/// 授权状态
typedef void (^QGLocationStatusBlock)(QGLocationStatus status);
/// 经纬度
typedef void (^QGLocationLoLaBlock)(double longitude,double latitude,NSError * _Nullable error);
/// 经纬度编译信息,placemark有可能是nil
typedef void(^QGLocationPlacemarkBlock)( CLPlacemark * _Nullable placemark);



@interface QGLocationManager : NSObject

/// 当前地理位置授权状态, 可用于判断
@property (nonatomic, assign, readonly) QGLocationStatus status;

/// 可用于监听授权变化
@property (nonatomic, copy) QGLocationStatusBlock statusBlock;

/// 单例
+ (instancetype)shareManager;

/// 请求地理位置权限,如果之前已经选择过,会直接返回当前的状态status
- (void)requestLocationAuthorizationStatus:(_Nullable QGLocationStatusBlock)statusBlock;


/// 获取经纬度信息和地址信息
/// Notice: placemarkBlock 如果传值NULL,则不进行反编译
/// @param lolaBlock 经纬度信息
/// Notice:先判断error是否为nil
/// @param placemarkBlock 地址信息:省-市-区, 其中placemark返回有可能是nil
- (void)requestLocationinformationLoLaBlock:(QGLocationLoLaBlock)lolaBlock placemarkBlock:(_Nullable QGLocationPlacemarkBlock)placemarkBlock;


/// 地址编译
/// @param address 地址信息
/// @param lolaBlock 经纬度信息
- (void)geocoderAddress:(NSString *)address complete:(QGLocationLoLaBlock)lolaBlock;



/// 地理反编译
/// @param longitude 经度
/// @param latitude 纬度
/// @param placemarkBlock 地址信息
- (void)reverseGeocoderLongitude:(double)longitude latitude:(double)latitude complete:(QGLocationPlacemarkBlock)placemarkBlock;

@end

NS_ASSUME_NONNULL_END
